/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openai.autoconfigure;

import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.model.openai.autoconfigure.OpenAIAutoConfigurationUtil;
import org.springframework.ai.model.openai.autoconfigure.OpenAiAudioSpeechProperties;
import org.springframework.ai.model.openai.autoconfigure.OpenAiConnectionProperties;
import org.springframework.ai.openai.OpenAiAudioSpeechModel;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={OpenAiApi.class})
@ConditionalOnProperty(name={"spring.ai.model.audio.speech"}, havingValue="openai", matchIfMissing=true)
@EnableConfigurationProperties(value={OpenAiConnectionProperties.class, OpenAiAudioSpeechProperties.class})
public class OpenAiAudioSpeechAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAiAudioSpeechModel openAiAudioSpeechModel(OpenAiConnectionProperties commonProperties, OpenAiAudioSpeechProperties speechProperties, RetryTemplate retryTemplate, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        OpenAIAutoConfigurationUtil.ResolvedConnectionProperties resolved = OpenAIAutoConfigurationUtil.resolveConnectionProperties(commonProperties, speechProperties, "speech");
        OpenAiAudioApi openAiAudioApi = OpenAiAudioApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).webClientBuilder((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).responseErrorHandler(responseErrorHandler).build();
        return new OpenAiAudioSpeechModel(openAiAudioApi, speechProperties.getOptions());
    }
}

