/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openaisdk.autoconfigure;

import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.client.OpenAIClient;
import com.openai.credential.Credential;
import io.micrometer.observation.ObservationRegistry;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkAutoConfigurationUtil;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkConnectionProperties;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkImageProperties;
import org.springframework.ai.openaisdk.OpenAiSdkImageModel;
import org.springframework.ai.openaisdk.setup.OpenAiSdkSetup;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(name={"spring.ai.model.image"}, havingValue="openai-sdk", matchIfMissing=true)
@EnableConfigurationProperties(value={OpenAiSdkConnectionProperties.class, OpenAiSdkImageProperties.class})
public class OpenAiSdkImageAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAiSdkImageModel openAiImageModel(OpenAiSdkConnectionProperties commonProperties, OpenAiSdkImageProperties imageProperties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ImageModelObservationConvention> observationConvention) {
        OpenAiSdkImageModel imageModel = new OpenAiSdkImageModel(this.openAiClient(commonProperties, imageProperties), imageProperties.getOptions(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((OpenAiSdkImageModel)imageModel).setObservationConvention(arg_0));
        return imageModel;
    }

    private OpenAIClient openAiClient(OpenAiSdkConnectionProperties commonProperties, OpenAiSdkImageProperties imageProperties) {
        OpenAiSdkAutoConfigurationUtil.ResolvedConnectionProperties resolved = OpenAiSdkAutoConfigurationUtil.resolveConnectionProperties(commonProperties, imageProperties);
        return OpenAiSdkSetup.setupSyncClient((String)resolved.getBaseUrl(), (String)resolved.getApiKey(), (Credential)resolved.getCredential(), (String)resolved.getMicrosoftDeploymentName(), (AzureOpenAIServiceVersion)resolved.getMicrosoftFoundryServiceVersion(), (String)resolved.getOrganizationId(), (boolean)resolved.isMicrosoftFoundry(), (boolean)resolved.isGitHubModels(), (String)resolved.getModel(), (Duration)resolved.getTimeout(), (Integer)resolved.getMaxRetries(), (Proxy)resolved.getProxy(), (Map)resolved.getCustomHeaders());
    }
}

