/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.chat.memory.redis.autoconfigure;

import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.memory.repository.redis.RedisChatMemoryRepository;
import org.springframework.ai.model.chat.memory.redis.autoconfigure.RedisChatMemoryProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPooled;

@AutoConfiguration(after={DataRedisAutoConfiguration.class})
@ConditionalOnClass(value={RedisChatMemoryRepository.class, JedisPooled.class})
@EnableConfigurationProperties(value={RedisChatMemoryProperties.class})
public class RedisChatMemoryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JedisPooled jedisClient(RedisChatMemoryProperties properties) {
        return new JedisPooled(properties.getHost(), properties.getPort());
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisChatMemoryRepository.class, ChatMemory.class, ChatMemoryRepository.class})
    public RedisChatMemoryRepository redisChatMemory(JedisPooled jedisClient, RedisChatMemoryProperties properties) {
        RedisChatMemoryRepository.Builder builder = RedisChatMemoryRepository.builder().jedisClient(jedisClient);
        if (StringUtils.hasText((String)properties.getIndexName())) {
            builder.indexName(properties.getIndexName());
        }
        if (StringUtils.hasText((String)properties.getKeyPrefix())) {
            builder.keyPrefix(properties.getKeyPrefix());
        }
        if (properties.getTimeToLive() != null && properties.getTimeToLive().toSeconds() > 0L) {
            builder.timeToLive(properties.getTimeToLive());
        }
        if (properties.getInitializeSchema() != null) {
            builder.initializeSchema(properties.getInitializeSchema().booleanValue());
        }
        if (properties.getMaxConversationIds() != null) {
            builder.maxConversationIds(properties.getMaxConversationIds().intValue());
        }
        if (properties.getMaxMessagesPerConversation() != null) {
            builder.maxMessagesPerConversation(properties.getMaxMessagesPerConversation().intValue());
        }
        if (properties.getMetadataFields() != null && !properties.getMetadataFields().isEmpty()) {
            builder.metadataFields(properties.getMetadataFields());
        }
        return builder.build();
    }
}

