/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProviderBase;
import io.modelcontextprotocol.spec.McpStreamableServerTransportProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.springframework.ai.mcp.customizer.McpAsyncServerCustomizer;
import org.springframework.ai.mcp.customizer.McpSyncServerCustomizer;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerChangeNotificationProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

@AutoConfiguration(afterName={"org.springframework.ai.mcp.server.common.autoconfigure.annotations.McpServerSpecificationFactoryAutoConfiguration", "org.springframework.ai.mcp.server.common.autoconfigure.ToolCallbackConverterAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerSseWebFluxAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerSseWebMvcAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerStreamableHttpWebMvcAutoConfiguration", "org.springframework.ai.mcp.server.autoconfigure.McpServerStreamableHttpWebFluxAutoConfiguration"})
@ConditionalOnClass(value={McpSchema.class})
@EnableConfigurationProperties(value={McpServerProperties.class, McpServerChangeNotificationProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Conditional(value={NonStatelessServerCondition.class})
public class McpServerAutoConfiguration {
    private static final LogAccessor logger = new LogAccessor(McpServerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public McpServerTransportProviderBase stdioServerTransport(@Qualifier(value="mcpServerObjectMapper") ObjectMapper mcpServerObjectMapper) {
        return new StdioServerTransportProvider((McpJsonMapper)new JacksonMcpJsonMapper(mcpServerObjectMapper));
    }

    @Bean
    @ConditionalOnMissingBean
    public McpSchema.ServerCapabilities.Builder capabilitiesBuilder() {
        return McpSchema.ServerCapabilities.builder();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public McpSyncServer mcpSyncServer(McpServerTransportProviderBase transportProvider, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, McpServerChangeNotificationProperties changeNotificationProperties, ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools, ObjectProvider<List<McpServerFeatures.SyncResourceSpecification>> resources, ObjectProvider<List<McpServerFeatures.SyncResourceTemplateSpecification>> resourceTemplates, ObjectProvider<List<McpServerFeatures.SyncPromptSpecification>> prompts, ObjectProvider<List<McpServerFeatures.SyncCompletionSpecification>> completions, ObjectProvider<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, Optional<McpSyncServerCustomizer> mcpSyncServerCustomizer) {
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        Object serverBuilder = transportProvider instanceof McpStreamableServerTransportProvider ? McpServer.sync((McpStreamableServerTransportProvider)((McpStreamableServerTransportProvider)transportProvider)) : McpServer.sync((McpServerTransportProvider)((McpServerTransportProvider)transportProvider));
        serverBuilder.serverInfo(serverInfo);
        if (serverProperties.getCapabilities().isTool()) {
            logger.info((CharSequence)("Enable tools capabilities, notification: " + changeNotificationProperties.isToolChangeNotification()));
            capabilitiesBuilder.tools(Boolean.valueOf(changeNotificationProperties.isToolChangeNotification()));
            ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
            if (!CollectionUtils.isEmpty(toolSpecifications)) {
                serverBuilder.tools(toolSpecifications);
                logger.info((CharSequence)("Registered tools: " + toolSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            logger.info((CharSequence)("Enable resources capabilities, notification: " + changeNotificationProperties.isResourceChangeNotification()));
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(changeNotificationProperties.isResourceChangeNotification()));
            List resourceSpecifications = resources.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resources(resourceSpecifications);
                logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            logger.info((CharSequence)("Enable resources templates capabilities, notification: " + changeNotificationProperties.isResourceChangeNotification()));
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(changeNotificationProperties.isResourceChangeNotification()));
            List resourceTemplateSpecifications = resourceTemplates.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceTemplateSpecifications)) {
                serverBuilder.resourceTemplates(resourceTemplateSpecifications);
                logger.info((CharSequence)("Registered resource templates: " + resourceTemplateSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isPrompt()) {
            logger.info((CharSequence)("Enable prompts capabilities, notification: " + changeNotificationProperties.isPromptChangeNotification()));
            capabilitiesBuilder.prompts(Boolean.valueOf(changeNotificationProperties.isPromptChangeNotification()));
            List promptSpecifications = prompts.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(promptSpecifications)) {
                serverBuilder.prompts(promptSpecifications);
                logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isCompletion()) {
            logger.info((CharSequence)"Enable completions capabilities");
            capabilitiesBuilder.completions();
            List completionSpecifications = completions.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(completionSpecifications)) {
                serverBuilder.completions(completionSpecifications);
                logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
            }
        }
        rootsChangeConsumers.ifAvailable(arg_0 -> McpServerAutoConfiguration.lambda$mcpSyncServer$0((McpServer.SyncSpecification)serverBuilder, arg_0));
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        serverBuilder.requestTimeout(serverProperties.getRequestTimeout());
        mcpSyncServerCustomizer.ifPresent(arg_0 -> McpServerAutoConfiguration.lambda$mcpSyncServer$2((McpServer.SyncSpecification)serverBuilder, arg_0));
        return serverBuilder.build();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    McpSyncServerCustomizer servletMcpSyncServerCustomizer() {
        return serverBuilder -> serverBuilder.immediateExecution(true);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public McpAsyncServer mcpAsyncServer(McpServerTransportProviderBase transportProvider, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, McpServerChangeNotificationProperties changeNotificationProperties, ObjectProvider<List<McpServerFeatures.AsyncToolSpecification>> tools, ObjectProvider<List<McpServerFeatures.AsyncResourceSpecification>> resources, ObjectProvider<List<McpServerFeatures.AsyncResourceTemplateSpecification>> resourceTemplates, ObjectProvider<List<McpServerFeatures.AsyncPromptSpecification>> prompts, ObjectProvider<List<McpServerFeatures.AsyncCompletionSpecification>> completions, ObjectProvider<BiConsumer<McpAsyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumer, Optional<McpAsyncServerCustomizer> asyncServerCustomizer) {
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.AsyncSpecification serverBuilder = transportProvider instanceof McpStreamableServerTransportProvider ? McpServer.async((McpStreamableServerTransportProvider)((McpStreamableServerTransportProvider)transportProvider)) : McpServer.async((McpServerTransportProvider)((McpServerTransportProvider)transportProvider));
        serverBuilder.serverInfo(serverInfo);
        if (serverProperties.getCapabilities().isTool()) {
            ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
            logger.info((CharSequence)("Enable tools capabilities, notification: " + changeNotificationProperties.isToolChangeNotification()));
            capabilitiesBuilder.tools(Boolean.valueOf(changeNotificationProperties.isToolChangeNotification()));
            if (!CollectionUtils.isEmpty(toolSpecifications)) {
                serverBuilder.tools(toolSpecifications);
                logger.info((CharSequence)("Registered tools: " + toolSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            logger.info((CharSequence)("Enable resources capabilities, notification: " + changeNotificationProperties.isResourceChangeNotification()));
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(changeNotificationProperties.isResourceChangeNotification()));
            List resourceSpecifications = resources.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceSpecifications)) {
                serverBuilder.resources(resourceSpecifications);
                logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isResource()) {
            logger.info((CharSequence)("Enable resources templates capabilities, notification: " + changeNotificationProperties.isResourceChangeNotification()));
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(changeNotificationProperties.isResourceChangeNotification()));
            List resourceTemplateSpecifications = resourceTemplates.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(resourceTemplateSpecifications)) {
                serverBuilder.resourceTemplates(resourceTemplateSpecifications);
                logger.info((CharSequence)("Registered resources templates: " + resourceTemplateSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isPrompt()) {
            logger.info((CharSequence)("Enable prompts capabilities, notification: " + changeNotificationProperties.isPromptChangeNotification()));
            capabilitiesBuilder.prompts(Boolean.valueOf(changeNotificationProperties.isPromptChangeNotification()));
            List promptSpecifications = prompts.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(promptSpecifications)) {
                serverBuilder.prompts(promptSpecifications);
                logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size()));
            }
        }
        if (serverProperties.getCapabilities().isCompletion()) {
            logger.info((CharSequence)"Enable completions capabilities");
            capabilitiesBuilder.completions();
            List completionSpecifications = completions.stream().flatMap(Collection::stream).toList();
            if (!CollectionUtils.isEmpty(completionSpecifications)) {
                serverBuilder.completions(completionSpecifications);
                logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
            }
        }
        rootsChangeConsumer.ifAvailable(consumer -> {
            BiFunction<McpAsyncServerExchange, List, Mono> asyncConsumer = (exchange, roots) -> {
                consumer.accept(exchange, roots);
                return Mono.empty();
            };
            serverBuilder.rootsChangeHandler(asyncConsumer);
            logger.info((CharSequence)"Registered roots change consumer");
        });
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        serverBuilder.requestTimeout(serverProperties.getRequestTimeout());
        asyncServerCustomizer.ifPresent(customizer -> customizer.customize(serverBuilder));
        return serverBuilder.build();
    }

    private static /* synthetic */ void lambda$mcpSyncServer$2(McpServer.SyncSpecification serverBuilder, McpSyncServerCustomizer customizer) {
        customizer.customize(serverBuilder);
    }

    private static /* synthetic */ void lambda$mcpSyncServer$0(McpServer.SyncSpecification serverBuilder, BiConsumer consumer) {
        BiConsumer<McpSyncServerExchange, List> syncConsumer = (exchange, roots) -> consumer.accept(exchange, roots);
        serverBuilder.rootsChangeHandler(syncConsumer);
        logger.info((CharSequence)"Registered roots change consumer");
    }

    public static class EnabledStreamableServerCondition
    extends AllNestedConditions {
        public EnabledStreamableServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"protocol"}, havingValue="STREAMABLE", matchIfMissing=false)
        static class StreamableEnabledCondition {
            StreamableEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class McpServerEnabledCondition {
            McpServerEnabledCondition() {
            }
        }
    }

    public static class EnabledSseServerCondition
    extends AllNestedConditions {
        public EnabledSseServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"protocol"}, havingValue="SSE", matchIfMissing=true)
        static class SseEnabledCondition {
            SseEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
        static class McpServerEnabledCondition {
            McpServerEnabledCondition() {
            }
        }
    }

    public static class NonStatelessServerCondition
    extends AnyNestedCondition {
        public NonStatelessServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"protocol"}, havingValue="STREAMABLE", matchIfMissing=false)
        static class StreamableEnabledCondition {
            StreamableEnabledCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"protocol"}, havingValue="SSE", matchIfMissing=true)
        static class SseEnabledCondition {
            SseEnabledCondition() {
            }
        }
    }
}

