/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.util.Assert;

public final class CitationDocument {
    private DocumentType type;
    private String title;
    private String context;
    private Object sourceData;
    private boolean citationsEnabled = false;

    private CitationDocument() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public AnthropicApi.ContentBlock toContentBlock() {
        AnthropicApi.ContentBlock.Source source = this.createSource();
        return new AnthropicApi.ContentBlock(source, this.title, this.context, this.citationsEnabled, null);
    }

    private AnthropicApi.ContentBlock.Source createSource() {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new AnthropicApi.ContentBlock.Source("text", "text/plain", (String)this.sourceData, null, null);
            case 1 -> {
                String base64Data = Base64.getEncoder().encodeToString((byte[])this.sourceData);
                yield new AnthropicApi.ContentBlock.Source("base64", "application/pdf", base64Data, null, null);
            }
            case 2 -> {
                List content = (List)this.sourceData;
                yield new AnthropicApi.ContentBlock.Source("content", null, null, null, content);
            }
        };
    }

    public boolean isCitationsEnabled() {
        return this.citationsEnabled;
    }

    public static class Builder {
        private final CitationDocument document = new CitationDocument();

        public Builder plainText(String text) {
            Assert.hasText((String)text, (String)"Text content cannot be null or empty");
            this.document.type = DocumentType.PLAIN_TEXT;
            this.document.sourceData = text;
            return this;
        }

        public Builder pdf(byte[] pdfBytes) {
            Assert.notNull((Object)pdfBytes, (String)"PDF bytes cannot be null");
            Assert.isTrue((pdfBytes.length > 0 ? 1 : 0) != 0, (String)"PDF bytes cannot be empty");
            this.document.type = DocumentType.PDF;
            this.document.sourceData = pdfBytes;
            return this;
        }

        public Builder pdfFile(String filePath) throws IOException {
            Assert.hasText((String)filePath, (String)"File path cannot be null or empty");
            byte[] pdfBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            return this.pdf(pdfBytes);
        }

        public Builder customContent(List<AnthropicApi.ContentBlock> contentBlocks) {
            Assert.notNull(contentBlocks, (String)"Content blocks cannot be null");
            Assert.notEmpty(contentBlocks, (String)"Content blocks cannot be empty");
            this.document.type = DocumentType.CUSTOM_CONTENT;
            this.document.sourceData = new ArrayList<AnthropicApi.ContentBlock>(contentBlocks);
            return this;
        }

        public Builder customContent(String ... textBlocks) {
            Assert.notNull((Object)textBlocks, (String)"Text blocks cannot be null");
            Assert.notEmpty((Object[])textBlocks, (String)"Text blocks cannot be empty");
            List<AnthropicApi.ContentBlock> blocks = Arrays.stream(textBlocks).map(AnthropicApi.ContentBlock::new).collect(Collectors.toList());
            return this.customContent(blocks);
        }

        public Builder title(String title) {
            this.document.title = title;
            return this;
        }

        public Builder context(String context) {
            this.document.context = context;
            return this;
        }

        public Builder citationsEnabled(boolean enabled) {
            this.document.citationsEnabled = enabled;
            return this;
        }

        public CitationDocument build() {
            Assert.notNull((Object)((Object)this.document.type), (String)"Document type must be specified");
            Assert.notNull((Object)this.document.sourceData, (String)"Document source data must be specified");
            return this.document;
        }
    }

    public static enum DocumentType {
        PLAIN_TEXT,
        PDF,
        CUSTOM_CONTENT;

    }
}

