/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core;

import io.swagger.v3.oas.models.Operation;
import java.util.List;
import java.util.Optional;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.webmvc.api.ActuatorProvider;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springdoc.webmvc.core.RequestBuilder;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocWebMvcConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    OpenApiResource openApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> servletContextProvider, SpringDocConfigProperties springDocConfigProperties, Optional<List<OpenApiCustomiser>> openApiCustomisers, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider) {
        return new OpenApiResource("springdocDefault", openAPIBuilder, requestBuilder, responseBuilder, operationParser, requestMappingHandlerMapping, servletContextProvider, openApiCustomisers, springDocConfigProperties, springSecurityOAuth2Provider);
    }

    @Bean
    @ConditionalOnMissingBean
    RequestBuilder requestBuilder(GenericParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, OperationBuilder operationBuilder, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return new RequestBuilder(parameterBuilder, requestBodyBuilder, operationBuilder, operationCustomizers, parameterCustomizers, localSpringDocParameterNameDiscoverer);
    }

    @Bean
    @ConditionalOnMissingBean
    GenericResponseBuilder responseBuilder(OperationBuilder operationBuilder, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new GenericResponseBuilder(operationBuilder, returnTypeParsers, springDocConfigProperties, propertyResolverUtils);
    }

    @ConditionalOnProperty(value={"springdoc.show-actuator"})
    @ConditionalOnClass(value={WebMvcEndpointHandlerMapping.class})
    class SpringDocWebMvcActuatorConfiguration {
        SpringDocWebMvcActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ActuatorProvider actuatorProvider(WebMvcEndpointHandlerMapping webMvcEndpointHandlerMapping) {
            return new ActuatorProvider(webMvcEndpointHandlerMapping);
        }

        @Bean
        @Lazy(value=false)
        OperationCustomizer actuatorCustomizer(final ActuatorProvider actuatorProvider) {
            return new OperationCustomizer(){
                private int methodCount;

                public Operation customize(Operation operation, HandlerMethod handlerMethod) {
                    if (operation.getTags() != null && operation.getTags().contains(actuatorProvider.getTag().getName())) {
                        operation.setSummary(handlerMethod.toString());
                        operation.setOperationId(operation.getOperationId() + "_" + this.methodCount++);
                    }
                    return operation;
                }
            };
        }
    }
}

