/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.api.ActuatorProvider;
import org.springdoc.api.OpenApiCustomiser;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class OpenApiResource
extends AbstractOpenApiResource {
    private RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    @Autowired(required=false)
    private ActuatorProvider servletContextProvider;
    @Value(value="${springdoc.show.actuator:false}")
    private boolean showActuator;

    public OpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<List<OpenApiCustomiser>> openApiCustomisers) {
        super(openAPIBuilder, requestBuilder, responseBuilder, operationParser, openApiCustomisers);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map);
        if (this.showActuator) {
            map = this.servletContextProvider.getWebMvcHandlerMapping().getHandlerMethods();
            HashSet handlerMethods = new HashSet(map.values());
            this.openAPIBuilder.addTag(handlerMethods, "Actuator");
            this.calculatePath(restControllers, map);
        }
    }

    private void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            PatternsRequestCondition patternsRequestCondition;
            Set patterns;
            String operationPath;
            RequestMappingInfo requestMappingInfo = entry.getKey();
            HandlerMethod handlerMethod = entry.getValue();
            if (!this.isRestController(restControllers, handlerMethod, operationPath = CollectionUtils.isEmpty((Collection)(patterns = (patternsRequestCondition = requestMappingInfo.getPatternsCondition()).getPatterns())) ? "/" : (String)patterns.iterator().next())) continue;
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            this.calculatePath(this.openAPIBuilder, handlerMethod, operationPath, requestMethods);
        }
    }

    private boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        boolean result = this.showActuator ? operationPath.startsWith("/") : operationPath.startsWith("/") && restControllers.containsKey(handlerMethod.getBean().toString());
        return result;
    }

    private void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        StringBuffer requestUrl = request.getRequestURL();
        String serverBaseUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.openAPIBuilder.setServerBaseUrl(serverBaseUrl);
    }
}

