/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import java.util.Optional;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerWelcomeWebFlux
extends SwaggerWelcomeCommon {
    private String webfluxBasePath = "";

    public SwaggerWelcomeWebFlux(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, Optional<WebFluxProperties> webFluxPropertiesOptional) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        webFluxPropertiesOptional.ifPresent(webFluxProperties -> {
            this.webfluxBasePath = webFluxProperties.getBasePath();
        });
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        return super.redirectToUi(request, response);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        return super.getSwaggerUiConfig(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (this.oauthPrefix == null && !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfigParameters.getOauth2RedirectUrl())) {
            this.oauthPrefix = uriComponentsBuilder.path(this.webfluxBasePath).path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(this.oauthPrefix.path(this.swaggerUiConfigParameters.getOauth2RedirectUrl()).build().toString());
        }
    }
}

