/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.ResourceTransformer;

@Configuration
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerConfig
implements WebFluxConfigurer {
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${springdoc.webjars.prefix:/webjars}")
    private String webJarsPrefixUrl;
    @Autowired
    private SwaggerIndexTransformer swaggerIndexTransformer;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf(47));
        }
        registry.addResourceHandler(new String[]{uiRootPath + this.webJarsPrefixUrl + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    SwaggerIndexTransformer indexPageTransformer(SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        return new SwaggerIndexTransformer(swaggerUiOAuthProperties, objectMapper);
    }
}

