/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.webflux.core.visitor.RouterFunctionVisitor;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MimeType;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public abstract class OpenApiResource
extends AbstractOpenApiResource {
    public OpenApiResource(String groupName, ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
    }

    public OpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
    }

    protected Mono<String> openapiJson(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return Mono.just((Object)this.writeJsonValue(openAPI));
    }

    protected Mono<String> openapiYaml(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl, locale);
        OpenAPI openAPI = this.getOpenApi(locale);
        return Mono.just((Object)this.writeYamlValue(openAPI));
    }

    protected void getPaths(Map<String, Object> restControllers, Locale locale) {
        Map beansOfTypeRequestMappingHandlerMapping = this.openAPIService.getContext().getBeansOfType(RequestMappingHandlerMapping.class);
        for (RequestMappingHandlerMapping requestMappingHandlerMapping : beansOfTypeRequestMappingHandlerMapping.values()) {
            Map map = requestMappingHandlerMapping.getHandlerMethods();
            this.calculatePath(restControllers, map, locale);
            if (!this.isShowActuator()) continue;
            map = ((ActuatorProvider)this.optionalActuatorProvider.get()).getMethods();
            this.openAPIService.addTag(new HashSet(map.values()), ActuatorProvider.getTag());
            this.calculatePath(restControllers, map, locale);
        }
        this.getWebFluxRouterFunctionPaths(locale);
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map, Locale locale) {
        ArrayList<Map.Entry<RequestMappingInfo, HandlerMethod>> entries = new ArrayList<Map.Entry<RequestMappingInfo, HandlerMethod>>(map.entrySet());
        entries.sort(this.byReversedRequestMappingInfos());
        for (Map.Entry entry : entries) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            for (PathPattern pathPattern : patterns) {
                String operationPath = pathPattern.getPatternString();
                LinkedHashMap regexMap = new LinkedHashMap();
                operationPath = PathUtils.parsePath((String)operationPath, regexMap);
                String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                if (!this.isRestController(restControllers, handlerMethod, operationPath) && !this.isActuatorRestController(operationPath, handlerMethod) || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                if (requestMethods.isEmpty()) {
                    requestMethods = this.getDefaultAllowedHttpMethods();
                }
                this.calculatePath(handlerMethod, operationPath, requestMethods, locale);
            }
        }
    }

    private Comparator<Map.Entry<RequestMappingInfo, HandlerMethod>> byReversedRequestMappingInfos() {
        return Comparator.comparing(a -> ((RequestMappingInfo)a.getKey()).toString()).reversed();
    }

    protected void getWebFluxRouterFunctionPaths(Locale locale) {
        ApplicationContext applicationContext = this.openAPIService.getContext();
        Map routerBeans = Objects.requireNonNull(applicationContext).getBeansOfType(RouterFunction.class);
        for (Map.Entry entry : routerBeans.entrySet()) {
            RouterFunction routerFunction = (RouterFunction)entry.getValue();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor();
            routerFunction.accept((RouterFunctions.Visitor)routerFunctionVisitor);
            this.getRouterFunctionPaths((String)entry.getKey(), routerFunctionVisitor, locale);
        }
    }

    protected void calculateServerUrl(ServerHttpRequest serverHttpRequest, String apiDocsUrl, Locale locale) {
        this.initOpenAPIBuilder(locale);
        String serverUrl = this.getServerUrl(serverHttpRequest, apiDocsUrl);
        this.openAPIService.setServerBaseUrl(serverUrl);
    }

    protected abstract String getServerUrl(ServerHttpRequest var1, String var2);
}

