/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.webflux.core.visitor.RouterFunctionVisitor;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

@RestController
public class OpenApiResource
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;

    public OpenApiResource(String groupName, ObjectFactory<OpenAPIBuilder> openAPIBuilderObjectFactory, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider) {
        super(groupName, openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Autowired
    public OpenApiResource(ObjectFactory<OpenAPIBuilder> openAPIBuilderObjectFactory, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public Mono<String> openapiJson(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        if (!this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter()) {
            return Mono.just((Object)Json.mapper().writeValueAsString((Object)openAPI));
        }
        return Mono.just((Object)Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI));
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public Mono<String> openapiYaml(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(serverHttpRequest, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        if (!this.springDocConfigProperties.isWriterWithDefaultPrettyPrinter()) {
            return Mono.just((Object)this.getYamlMapper().writeValueAsString((Object)openAPI));
        }
        return Mono.just((Object)this.getYamlMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI));
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map);
        if (this.actuatorProvider.isPresent()) {
            map = ((ActuatorProvider)this.actuatorProvider.get()).getMethods();
            this.openAPIBuilder.addTag(new HashSet(map.values()), ((ActuatorProvider)this.actuatorProvider.get()).getTag());
            this.calculatePath(restControllers, map);
        }
        this.getWebFluxRouterFunctionPaths();
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = entry.getKey();
            HandlerMethod handlerMethod = entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            for (PathPattern pathPattern : patterns) {
                String operationPath = pathPattern.getPatternString();
                LinkedHashMap regexMap = new LinkedHashMap();
                operationPath = PathUtils.parsePath((String)operationPath, regexMap);
                String[] produces = (String[])requestMappingInfo.getProducesCondition().getProducibleMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] consumes = (String[])requestMappingInfo.getConsumesCondition().getConsumableMediaTypes().stream().map(MimeType::toString).toArray(String[]::new);
                String[] headers = (String[])requestMappingInfo.getHeadersCondition().getExpressions().stream().map(Object::toString).toArray(String[]::new);
                if (!operationPath.startsWith("/") || !restControllers.containsKey(handlerMethod.getBean().toString()) && !this.actuatorProvider.isPresent() || !this.isFilterCondition(handlerMethod, operationPath, produces, consumes, headers)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                if (requestMethods.isEmpty()) {
                    requestMethods = this.getDefaultAllowedHttpMethods();
                }
                this.calculatePath(handlerMethod, operationPath, requestMethods);
            }
        }
    }

    protected void getWebFluxRouterFunctionPaths() {
        ApplicationContext applicationContext = this.requestMappingHandlerMapping.getApplicationContext();
        Map routerBeans = Objects.requireNonNull(applicationContext).getBeansOfType(RouterFunction.class);
        for (Map.Entry entry : routerBeans.entrySet()) {
            RouterFunction routerFunction = (RouterFunction)entry.getValue();
            RouterFunctionVisitor routerFunctionVisitor = new RouterFunctionVisitor();
            routerFunction.accept((RouterFunctions.Visitor)routerFunctionVisitor);
            this.getRouterFunctionPaths((String)entry.getKey(), routerFunctionVisitor);
        }
    }

    protected void calculateServerUrl(ServerHttpRequest serverHttpRequest, String apiDocsUrl) {
        super.initOpenAPIBuilder();
        String requestUrl = this.decode(serverHttpRequest.getURI().toString());
        String serverBaseUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.openAPIBuilder.setServerBaseUrl(serverBaseUrl);
    }
}

