/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseBuilder;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.webflux.api.OpenApiResource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import reactor.core.publisher.Mono;

@RestController
public class MultipleOpenApiResource
implements InitializingBean {
    private final List<GroupedOpenApi> groupedOpenApis;
    private final ObjectFactory<OpenAPIBuilder> defaultOpenAPIBuilder;
    private final AbstractRequestBuilder requestBuilder;
    private final GenericResponseBuilder responseBuilder;
    private final OperationBuilder operationParser;
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final SpringDocConfigProperties springDocConfigProperties;
    private Map<String, OpenApiResource> groupedOpenApiResources;
    private Optional<ActuatorProvider> actuatorProvider;

    public MultipleOpenApiResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIBuilder> defaultOpenAPIBuilder, AbstractRequestBuilder requestBuilder, GenericResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider) {
        this.groupedOpenApis = groupedOpenApis;
        this.defaultOpenAPIBuilder = defaultOpenAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.springDocConfigProperties = springDocConfigProperties;
        this.actuatorProvider = actuatorProvider;
    }

    public void afterPropertiesSet() throws Exception {
        this.groupedOpenApiResources = this.groupedOpenApis.stream().collect(Collectors.toMap(GroupedOpenApi::getGroup, item -> {
            SpringDocConfigProperties.GroupConfig groupConfig = new SpringDocConfigProperties.GroupConfig(item.getGroup(), item.getPathsToMatch(), item.getPackagesToScan(), item.getPackagesToExclude(), item.getPathsToExclude(), item.getProducesToMatch(), item.getConsumesToMatch(), item.getHeadersToMatch());
            this.springDocConfigProperties.addGroupConfig(groupConfig);
            return new OpenApiResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, this.requestMappingHandlerMapping, Optional.of(item.getOperationCustomizers()), Optional.of(item.getOpenApiCustomisers()), this.springDocConfigProperties, this.actuatorProvider);
        }));
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/{group}"}, produces={"application/json"})
    public Mono<String> openapiJson(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl, @PathVariable String group) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiJson(serverHttpRequest, apiDocsUrl + "/" + group);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml/{group}"}, produces={"application/vnd.oai.openapi"})
    public Mono<String> openapiYaml(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl, @PathVariable String group) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiYaml(serverHttpRequest, apiDocsUrl + "/" + group);
    }

    private OpenApiResource getOpenApiResourceOrThrow(String group) {
        OpenApiResource openApiResource = this.groupedOpenApiResources.get(group);
        if (openApiResource == null) {
            throw new OpenApiResourceNotFoundException("No OpenAPI resource found for group: " + group);
        }
        return openApiResource;
    }
}

