/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.springdoc.core.converters.ConverterUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFluxSupportConverter
implements ModelConverter {
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType javaType = Json.mapper().constructType(type.getType());
        if (javaType != null && Flux.class.isAssignableFrom(cls = javaType.getRawClass())) {
            JavaType innerType = javaType.getBindings().getBoundType(0);
            if (innerType.getBindings() != null && ConverterUtils.isResponseTypeWrapper((Class)innerType.getRawClass())) {
                type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
                return this.resolve(type, context, chain);
            }
            ArrayType arrayType = ArrayType.construct((JavaType)innerType, null);
            type = new AnnotatedType((Type)arrayType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    static {
        ConverterUtils.addResponseWrapperToIgnore(Mono.class);
    }
}

