/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springdoc.core.AbstractParameterBuilder;
import org.springdoc.core.IgnoredParameterAnnotations;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.web.multipart.MultipartFile;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ParameterBuilder
extends AbstractParameterBuilder {
    public ParameterBuilder(LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer, IgnoredParameterAnnotations ignoredParameterAnnotations) {
        super(localSpringDocParameterNameDiscoverer, ignoredParameterAnnotations);
    }

    protected Schema calculateSchemaFromParameterizedType(Components components, Type paramType, JsonView jsonView) {
        ParameterizedType parameterizedType = (ParameterizedType)paramType;
        Schema schemaN = Mono.class.getName().contentEquals(parameterizedType.getRawType().getTypeName()) || Flux.class.getName().contentEquals(parameterizedType.getRawType().getTypeName()) ? SpringDocAnnotationsUtils.extractSchema((Components)components, (Type)parameterizedType.getActualTypeArguments()[0], (JsonView)jsonView) : SpringDocAnnotationsUtils.extractSchema((Components)components, (Type)paramType, (JsonView)jsonView);
        return schemaN;
    }

    public boolean isFile(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getActualTypeArguments()[0];
        if (MultipartFile.class.getName().equals(type.getTypeName()) || FilePart.class.getName().equals(type.getTypeName())) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return MultipartFile.class.getName().equals(upperBounds[0].getTypeName());
        }
        return false;
    }

    public boolean isFile(JavaType ct) {
        return MultipartFile.class.isAssignableFrom(ct.getRawClass()) || FilePart.class.isAssignableFrom(ct.getRawClass());
    }
}

