/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ResponseBuilder
extends AbstractResponseBuilder {
    public ResponseBuilder(OperationBuilder operationBuilder) {
        super(operationBuilder);
    }

    protected Schema calculateSchemaFromParameterizedType(Components components, ParameterizedType parameterizedType, JsonView jsonView) {
        Schema schemaN = null;
        if (Mono.class.getName().contentEquals(parameterizedType.getRawType().getTypeName())) {
            if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ResponseEntity.class.getName().contentEquals(((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().getTypeName())) {
                ParameterizedType parameterizedTypeNew = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
                schemaN = this.calculateSchemaParameterizedType(components, parameterizedTypeNew, jsonView);
            } else {
                schemaN = this.calculateSchemaParameterizedType(components, parameterizedType, jsonView);
            }
        } else if (Flux.class.getName().contentEquals(parameterizedType.getRawType().getTypeName())) {
            if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && ResponseEntity.class.getName().contentEquals(((ParameterizedType)parameterizedType.getActualTypeArguments()[0]).getRawType().getTypeName())) {
                ParameterizedType parameterizedTypeNew = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
                schemaN = this.calculateFluxSchema(components, parameterizedTypeNew, jsonView);
            } else {
                schemaN = this.calculateFluxSchema(components, parameterizedType, jsonView);
            }
        } else if (ResponseEntity.class.getName().contentEquals(parameterizedType.getRawType().getTypeName())) {
            schemaN = this.calculateSchemaParameterizedType(components, parameterizedType, jsonView);
        }
        return schemaN;
    }

    private Schema calculateFluxSchema(Components components, ParameterizedType parameterizedType, JsonView jsonView) {
        Schema itemsSchema = SpringDocAnnotationsUtils.extractSchema((Components)components, (Type)parameterizedType.getActualTypeArguments()[0], (JsonView)jsonView);
        return new ArraySchema().items(itemsSchema);
    }
}

