/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.SecurityParser;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

@Component
public class InfoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoBuilder.class);
    @Autowired
    private ApplicationContext context;

    private InfoBuilder() {
    }

    public void build(OpenAPI openAPI) {
        Map openAPIDefinitionMap = this.context.getBeansWithAnnotation(OpenAPIDefinition.class);
        OpenAPIDefinition apiDef = null;
        if (openAPIDefinitionMap.size() > 1) {
            LOGGER.warn("found more than one OpenAPIDefinition class. springdoc-openapi will be using the first one found.");
        }
        if (openAPIDefinitionMap.size() > 0) {
            Map.Entry entry = openAPIDefinitionMap.entrySet().iterator().next();
            Class<?> objClz = entry.getValue().getClass();
            apiDef = (OpenAPIDefinition)ReflectionUtils.getAnnotation(objClz, OpenAPIDefinition.class);
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                apiDef = this.getApiDefClass(scanner, packagesToScan);
            }
        }
        if (apiDef != null) {
            AnnotationsUtils.getInfo((Info)apiDef.info()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setInfo(arg_0));
            SecurityParser.getSecurityRequirements(apiDef.security()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setSecurity(arg_0));
            AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiDef.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setExternalDocs(arg_0));
            AnnotationsUtils.getTags((Tag[])apiDef.tags(), (boolean)false).ifPresent(tags -> openAPI.setTags(new ArrayList(tags)));
            AnnotationsUtils.getServers((Server[])apiDef.servers()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setServers(arg_0));
            if (apiDef.extensions().length > 0) {
                openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])apiDef.extensions()));
            }
        } else {
            io.swagger.v3.oas.models.info.Info infos = new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
            openAPI.setInfo(infos);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }
}

