/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.AbstractOpenApiResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.support.RouterFunctionMapping;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

@RestController
public class OpenApiResource
extends AbstractOpenApiResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiResource.class);
    @Autowired
    private RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private RouterFunctionMapping routerFunctionMapping;
    @Autowired
    private ApplicationContext applicationContext;

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public Mono<String> openapiJson() throws JsonProcessingException {
        OpenAPI openAPI = this.getOpenApi();
        return Mono.just((Object)Json.mapper().writeValueAsString((Object)openAPI));
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public Mono<String> openapiYaml() throws JsonProcessingException {
        OpenAPI openAPI = this.getOpenApi();
        return Mono.just((Object)Yaml.mapper().writeValueAsString((Object)openAPI));
    }

    private OpenAPI getOpenApi() {
        List routerFunctions;
        long start = System.currentTimeMillis();
        this.infoBuilder.build(this.openAPIBuilder.getOpenAPI());
        RouterFunction routerFunction = this.routerFunctionMapping.getRouterFunction();
        SortedRouterFunctionsContainer container = new SortedRouterFunctionsContainer();
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)container);
        List list = routerFunctions = CollectionUtils.isEmpty((Collection)container.routerFunctions) ? Collections.emptyList() : container.routerFunctions;
        if (!CollectionUtils.isEmpty((Collection)routerFunctions)) {
            for (RouterFunction router : routerFunctions) {
                if (router instanceof RouterFunctions) {
                    LOGGER.info("done");
                }
                LOGGER.info("Mapped badou" + router.getClass());
            }
        }
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        Map findRestControllers1 = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(RestController.class);
        Map findRestControllers2 = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(RequestMapping.class);
        Map<String, Object> findRestControllers = Stream.of(findRestControllers1, findRestControllers2).flatMap(mapEl -> mapEl.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
        Map findControllerAdvice = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(ControllerAdvice.class);
        this.responseBuilder.buildGenericResponse(this.openAPIBuilder.getComponents(), findControllerAdvice);
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            for (PathPattern pathPattern : patterns) {
                String operationPath = pathPattern.getPatternString();
                if (operationPath == null || !operationPath.startsWith("/") || !findRestControllers.containsKey(handlerMethod.getBean().toString())) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                this.calculatePath(this.openAPIBuilder, handlerMethod, operationPath, requestMethods);
            }
        }
        this.openAPIBuilder.getOpenAPI().setPaths(this.openAPIBuilder.getPaths());
        LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)(System.currentTimeMillis() - start));
        return this.openAPIBuilder.getOpenAPI();
    }

    private static class SortedRouterFunctionsContainer {
        @Nullable
        private List<RouterFunction<?>> routerFunctions;

        private SortedRouterFunctionsContainer() {
        }

        @Autowired(required=false)
        public void setRouterFunctions(List<RouterFunction<?>> routerFunctions) {
            this.routerFunctions = routerFunctions;
        }
    }
}

