/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@Controller
public class SwaggerWelcomeWebMvc
extends SwaggerWelcomeCommon {
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    private String pathPrefix;
    private final Optional<List<RequestMappingInfoHandlerMapping>> requestMappingInfoHandlerMappingOptionalList;

    public SwaggerWelcomeWebMvc(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters, Optional<List<RequestMappingInfoHandlerMapping>> requestMappingInfoHandlerMappingOptionalList) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.requestMappingInfoHandlerMappingOptionalList = requestMappingInfoHandlerMappingOptionalList;
    }

    @PostConstruct
    private void init() {
        this.requestMappingInfoHandlerMappingOptionalList.ifPresent(requestMappingInfoHandlerMappingList -> requestMappingInfoHandlerMappingList.forEach(requestMappingHandlerMapping -> {
            Map map = requestMappingHandlerMapping.getHandlerMethods();
            ArrayList entries = new ArrayList(map.entrySet());
            for (Map.Entry entry : entries) {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
                Set patterns = OpenApiResource.getActivePatterns((RequestMappingInfo)requestMappingInfo);
                if (CollectionUtils.isEmpty((Collection)patterns)) continue;
                for (String operationPath : patterns) {
                    if (!operationPath.endsWith(this.springDocConfigProperties.getApiDocs().getPath())) continue;
                    this.pathPrefix = operationPath.replace(this.springDocConfigProperties.getApiDocs().getPath(), "");
                }
            }
        }));
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    protected void calculateUiRootPath(StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        this.calculateUiRootCommon(sbUrl, sbUrls);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        return super.buildUrl(contextPath, docsUrl);
    }

    protected String buildApiDocUrl() {
        return this.buildUrl(this.contextPath + this.pathPrefix, this.springDocConfigProperties.getApiDocs().getPath());
    }

    protected String buildSwaggerConfigUrl() {
        return this.apiDocsUrl + "/" + "swagger-config";
    }
}

