/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.ResourceTransformer;

public class SwaggerWebMvcConfigurer
extends WebMvcConfigurerAdapter {
    private String swaggerPath;
    private SwaggerIndexTransformer swaggerIndexTransformer;

    public SwaggerWebMvcConfigurer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerIndexTransformer swaggerIndexTransformer) {
        this.swaggerPath = swaggerUiConfig.getPath();
        this.swaggerIndexTransformer = swaggerIndexTransformer;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf(47));
        }
        uiRootPath.append("/**");
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }
}

