/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OpenAPIBuilder.class})
class SwaggerWelcome {
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    @Autowired
    private SwaggerUiConfigProperties swaggerUiConfig;

    SwaggerWelcome() {
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi(HttpServletRequest request) {
        String uiRootPath = "";
        if (this.swaggerPath.contains("/")) {
            uiRootPath = this.swaggerPath.substring(0, this.swaggerPath.lastIndexOf(47));
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("redirect:");
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        sbUrl.append(uiRootPath);
        sbUrl.append("/swagger-ui/index.html");
        this.buildConfigUrl(request);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl.toString());
        return uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfig.getConfigUrl()}).build().encode().toString();
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> openapiYaml(HttpServletRequest request) {
        this.buildConfigUrl(request);
        return this.swaggerUiConfig.getConfigParameters();
    }

    private String buildUrl(HttpServletRequest request, String docsUrl) {
        String contextPath = request.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        return contextPath + docsUrl;
    }

    private void buildConfigUrl(HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            String url = this.buildUrl(request, this.apiDocsUrl);
            String swaggerConfigUrl = url + "/" + "swagger-config";
            this.swaggerUiConfig.setConfigUrl(swaggerConfigUrl);
            if (SwaggerUiConfigProperties.getSwaggerUrls().isEmpty()) {
                this.swaggerUiConfig.setUrl(url);
            } else {
                SwaggerUiConfigProperties.addUrl((String)url);
            }
        }
    }
}

