/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
class SwaggerWelcome {
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;
    @Autowired
    private SwaggerUiConfigProperties swaggerUiConfig;

    SwaggerWelcome() {
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            contextPath = contextPath + this.mvcServletPath;
        }
        String uiRootPath = "";
        if (this.swaggerPath.contains("/")) {
            uiRootPath = this.swaggerPath.substring(0, this.swaggerPath.lastIndexOf(47));
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("redirect:");
        if (StringUtils.isNotBlank((CharSequence)this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        sbUrl.append(uiRootPath);
        sbUrl.append("/swagger-ui/index.html?url=");
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
            sbUrl.append(contextPath).append(this.apiDocsUrl);
        } else {
            sbUrl.append(contextPath).append(this.apiDocsUrl);
        }
        sbUrl.append("&validatorUrl=");
        Map params = this.swaggerUiConfig.getConfigParameters();
        UriComponentsBuilder builder = params.entrySet().stream().reduce(UriComponentsBuilder.fromUriString((String)sbUrl.toString()), (b, e) -> b.queryParam((String)e.getKey(), new Object[]{e.getValue()}), (left, right) -> left);
        return builder.build().encode().toString();
    }
}

