/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webflux.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerWelcomeWebFlux
extends SwaggerWelcomeCommon {
    private final ObjectProvider<SpringWebProvider> springWebProvider;

    public SwaggerWelcomeWebFlux(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, ObjectProvider<SpringWebProvider> springWebProvider) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.springWebProvider = springWebProvider;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public Mono<Void> redirectToUi(ServerWebExchange exchange) {
        return super.redirectToUi(exchange);
    }

    @Override
    protected void calculateUiRootPath(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        this.calculateUiRootCommon(swaggerUiConfigParameters, sbUrl, sbUrls);
    }

    protected void buildApiDocUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setApiDocsUrl(this.buildUrlWithContextPath(swaggerUiConfigParameters, this.springDocConfigProperties.getApiDocs().getPath()));
    }

    protected String buildUrlWithContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, String swaggerUiUrl) {
        if (swaggerUiConfigParameters.getPathPrefix() == null) {
            swaggerUiConfigParameters.setPathPrefix(((SpringWebProvider)this.springWebProvider.getIfAvailable()).findPathPrefix(this.springDocConfigProperties));
        }
        if (swaggerUiUrl.startsWith(swaggerUiConfigParameters.getPathPrefix())) {
            return this.buildUrl(swaggerUiConfigParameters.getContextPath(), swaggerUiUrl);
        }
        return this.buildUrl(swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getPathPrefix(), swaggerUiUrl);
    }

    protected void buildSwaggerConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setConfigUrl(swaggerUiConfigParameters.getApiDocsUrl() + "/swagger-config");
    }
}

