/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
    }

    protected Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        String webjarsPrefix = this.springDocConfigProperties.getWebjars().getPrefix();
        String additionalPrefix = "/webjars".equals(webjarsPrefix) ? "" : webjarsPrefix;
        String sbUrl = swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getUiRootPath() + additionalPrefix + this.getSwaggerUiUrl();
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(swaggerUiConfigParameters, sbUrl);
        request.getQueryParams().forEach((arg_0, arg_1) -> ((UriComponentsBuilder)uriBuilder).queryParam(arg_0, arg_1));
        response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }

    protected void calculateOauth2RedirectUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            String webjarsPrefix = this.springDocConfigProperties.getWebjars().getPrefix();
            String additionalPath = "/webjars".equals(webjarsPrefix) ? "" : webjarsPrefix;
            swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(swaggerUiConfigParameters.getUiRootPath()).path(additionalPath).path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        return swaggerUiConfigParameters.getConfigParameters();
    }

    void buildFromCurrentContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, ServerHttpRequest request) {
        super.init(swaggerUiConfigParameters);
        swaggerUiConfigParameters.setContextPath(request.getPath().contextPath().value());
        String url = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).toUriString();
        String target = UriComponentsBuilder.fromPath((String)request.getPath().contextPath().value()).toUriString();
        int endIndex = url.indexOf(target) + target.length();
        url = endIndex > 0 ? url.substring(0, endIndex) : url.replace(request.getPath().toString(), "");
        this.buildConfigUrl(swaggerUiConfigParameters, UriComponentsBuilder.fromUriString((String)url));
    }
}

