/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Locale;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webflux.api.MultipleOpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class MultipleOpenApiWebFluxResource
extends MultipleOpenApiResource {
    public MultipleOpenApiWebFluxResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIService> defaultOpenAPIBuilder, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        super(groupedOpenApis, defaultOpenAPIBuilder, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}/{group}"}, produces={"application/json"})
    public Mono<String> openapiJson(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl, @PathVariable String group, Locale locale) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiJson(serverHttpRequest, apiDocsUrl + "/" + group, locale);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}.yaml/{group}"}, produces={"application/vnd.oai.openapi"})
    public Mono<String> openapiYaml(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl, @PathVariable String group, Locale locale) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiYaml(serverHttpRequest, apiDocsUrl + "/" + group, locale);
    }
}

