/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.core.configuration;

import java.util.List;
import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.customizers.RouterOperationCustomizer;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springdoc.core.parsers.ReturnTypeParser;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.webflux.api.OpenApiActuatorResource;
import org.springdoc.webflux.api.OpenApiWebfluxResource;
import org.springdoc.webflux.core.configuration.MultipleOpenApiSupportConfiguration;
import org.springdoc.webflux.core.converters.WebFluxSupportConverter;
import org.springdoc.webflux.core.providers.ActuatorWebFluxProvider;
import org.springdoc.webflux.core.providers.SpringWebFluxProvider;
import org.springdoc.webflux.core.service.RequestService;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.reactive.ControllerEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.reactive.WebFluxEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocWebFluxConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.use-management-port"}, havingValue="false", matchIfMissing=true)
    @Lazy(value=false)
    OpenApiWebfluxResource openApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<RouterOperationCustomizer>> routerOperationCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
        return new OpenApiWebfluxResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomizers, routerOperationCustomizers, methodFilters, springDocConfigProperties, springDocProviders);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    RequestService requestBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, OperationService operationService, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return new RequestService(parameterBuilder, requestBodyService, operationService, parameterCustomizers, localSpringDocParameterNameDiscoverer);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    GenericResponseService responseBuilder(OperationService operationService, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new GenericResponseService(operationService, returnTypeParsers, springDocConfigProperties, propertyResolverUtils);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    WebFluxSupportConverter webFluxSupportConverter(ObjectMapperProvider objectMapperProvider) {
        return new WebFluxSupportConverter(objectMapperProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringWebProvider springWebProvider() {
        return new SpringWebFluxProvider();
    }

    @ConditionalOnClass(value={WebFluxEndpointHandlerMapping.class})
    static class SpringDocWebFluxActuatorConfiguration {
        SpringDocWebFluxActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnExpression(value="${springdoc.show-actuator:false} or ${springdoc.use-management-port:false}")
        @Lazy(value=false)
        ActuatorProvider actuatorProvider(ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties, Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties, Optional<WebFluxEndpointHandlerMapping> webFluxEndpointHandlerMapping, Optional<ControllerEndpointHandlerMapping> controllerEndpointHandlerMapping) {
            return new ActuatorWebFluxProvider(serverProperties, springDocConfigProperties, managementServerProperties, webEndpointProperties, webFluxEndpointHandlerMapping, controllerEndpointHandlerMapping);
        }

        @Bean
        @ConditionalOnMissingBean(value={MultipleOpenApiSupportConfiguration.class})
        @ConditionalOnProperty(value={"springdoc.use-management-port"})
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Lazy(value=false)
        OpenApiActuatorResource actuatorOpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomizer>> openApiCustomizers, Optional<List<RouterOperationCustomizer>> routerOperationCustomizers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders) {
            return new OpenApiActuatorResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomizers, routerOperationCustomizers, methodFilters, springDocConfigProperties, springDocProviders);
        }
    }
}

