/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.boot.web.server.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class SpringDocWebServerConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.web.server.context.WebServerInitializedEvent", "org.springframework.boot.web.server.autoconfigure.ServerProperties"})
    static class DeployedWebServerConfiguration {
        DeployedWebServerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={SpringDocWebServerContext.class})
        SpringDocWebServerContext webServerPortProvider() {
            return new SpringDocWebServerContext(){

                @Override
                public Supplier<Integer> getApplicationPort() {
                    return () -> -1;
                }

                @Override
                public Supplier<Integer> getActuatorPort() {
                    return () -> -1;
                }

                @Override
                public Supplier<ApplicationContext> getManagementApplicationContext() {
                    return () -> null;
                }

                @Override
                public String getContextPath() {
                    return "";
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebServerInitializedEvent.class, ServerProperties.class})
    static class EmbeddedWebServerConfiguration {
        EmbeddedWebServerConfiguration() {
        }

        @Bean
        SpringDocWebServerContext webServerPortProvider(ObjectProvider<ServerProperties> serverPropertiesProvider) {
            return new SpringDocWebServerPortListener(serverPropertiesProvider);
        }

        static final class SpringDocWebServerPortListener
        implements ApplicationListener<WebServerInitializedEvent>,
        SpringDocWebServerContext {
            private final String contextPath;
            private volatile Supplier<Integer> applicationPortSupplier;
            private volatile Supplier<Integer> actuatorPortSupplier;
            private volatile Supplier<ApplicationContext> managementContextSupplier;

            public SpringDocWebServerPortListener(ObjectProvider<ServerProperties> serverPropertiesProvider) {
                ServerProperties serverProperties = (ServerProperties)serverPropertiesProvider.getIfAvailable();
                this.contextPath = serverProperties != null ? (String)StringUtils.defaultIfEmpty((CharSequence)serverProperties.getServlet().getContextPath(), (CharSequence)"") : "";
            }

            public void onApplicationEvent(WebServerInitializedEvent event) {
                WebServer webServer = event.getWebServer();
                if (WebServerApplicationContext.hasServerNamespace((ApplicationContext)event.getApplicationContext(), (String)"management")) {
                    this.actuatorPortSupplier = () -> ((WebServer)webServer).getPort();
                    this.managementContextSupplier = () -> ((WebServerInitializedEvent)event).getApplicationContext();
                } else {
                    this.applicationPortSupplier = () -> ((WebServer)webServer).getPort();
                }
            }

            @Override
            public Supplier<Integer> getApplicationPort() {
                return this.applicationPortSupplier;
            }

            @Override
            public Supplier<Integer> getActuatorPort() {
                return this.actuatorPortSupplier;
            }

            @Override
            public Supplier<ApplicationContext> getManagementApplicationContext() {
                return this.managementContextSupplier;
            }

            @Override
            public String getContextPath() {
                return this.contextPath;
            }
        }
    }

    public static interface SpringDocWebServerContext {
        public Supplier<Integer> getApplicationPort();

        public Supplier<Integer> getActuatorPort();

        public Supplier<ApplicationContext> getManagementApplicationContext();

        public String getContextPath();
    }
}

