/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.utils.SpringDocUtils;

public class AdditionalModelsConverter
implements ModelConverter {
    private static final Map<Class, Class> modelToClassMap = new HashMap<Class, Class>();
    private static final Map<Class, Schema> modelToSchemaMap = new HashMap<Class, Schema>();
    private static final Map<Class, Class> paramObjectReplacementMap = new HashMap<Class, Class>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalModelsConverter.class);
    private final ObjectMapperProvider springDocObjectMapper;

    public AdditionalModelsConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public static void replaceWithClass(Class source, Class target) {
        modelToClassMap.put(source, target);
    }

    public static void replaceWithSchema(Class source, Schema target) {
        modelToSchemaMap.put(source, target);
    }

    public static void replaceParameterObjectWithClass(Class source, Class target) {
        paramObjectReplacementMap.put(source, target);
    }

    public static Class getParameterObjectReplacement(Class clazz) {
        return paramObjectReplacementMap.getOrDefault(clazz, clazz);
    }

    public static void disableReplacement(Class clazz) {
        modelToClassMap.remove(clazz);
    }

    public static void removeFromSchemaMap(Class clazz) {
        modelToSchemaMap.remove(clazz);
    }

    public static void removeFromClassMap(Class clazz) {
        modelToClassMap.remove(clazz);
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null) {
            Class cls = javaType.getRawClass();
            if (modelToSchemaMap.containsKey(cls)) {
                try {
                    Schema schema = modelToSchemaMap.get(cls);
                    if (this.springDocObjectMapper.isOpenapi31()) {
                        SpringDocUtils.handleSchemaTypes(schema);
                    }
                    return (Schema)this.springDocObjectMapper.jsonMapper().readValue(this.springDocObjectMapper.jsonMapper().writeValueAsString((Object)schema), (TypeReference)new TypeReference<Schema>(){});
                }
                catch (JsonProcessingException e) {
                    LOGGER.warn("Json Processing Exception occurred: {}", (Object)e.getMessage());
                }
            }
            if (modelToClassMap.containsKey(cls)) {
                type = new AnnotatedType((Type)modelToClassMap.get(cls)).resolveAsRef(true);
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

