/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springdoc.core.providers.JavadocProvider;
import org.springframework.util.CollectionUtils;

public record JavadocPropertyCustomizer(JavadocProvider javadocProvider) implements ModelConverter
{
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType;
        if (chain.hasNext() && (javaType = Json.mapper().constructType(type.getType())) != null) {
            Class cls = javaType.getRawClass();
            Schema resolvedSchema = chain.next().resolve(type, context, chain);
            List fields = FieldUtils.getAllFieldsList((Class)cls);
            if (!CollectionUtils.isEmpty((Collection)fields)) {
                if (!type.isSchemaProperty()) {
                    Schema existingSchema = context.resolve(type);
                    this.setJavadocDescription(fields, existingSchema);
                } else if (resolvedSchema != null && resolvedSchema.get$ref() != null && resolvedSchema.get$ref().contains("#/components/schemas/")) {
                    String schemaName = resolvedSchema.get$ref().substring(21);
                    Schema existingSchema = (Schema)context.getDefinedModels().get(schemaName);
                    this.setJavadocDescription(fields, existingSchema);
                }
            }
            return resolvedSchema;
        }
        return null;
    }

    private void setJavadocDescription(List<Field> fields, Schema existingSchema) {
        Map properties;
        if (existingSchema != null && !CollectionUtils.isEmpty((Map)(properties = existingSchema.getProperties()))) {
            properties.entrySet().stream().filter(stringSchemaEntry -> StringUtils.isBlank((CharSequence)((Schema)stringSchemaEntry.getValue()).getDescription())).forEach(stringSchemaEntry -> {
                Optional<Field> optionalField = fields.stream().filter(field1 -> field1.getName().equals(stringSchemaEntry.getKey())).findAny();
                optionalField.ifPresent(field -> {
                    String fieldJavadoc = this.javadocProvider.getFieldJavadoc((Field)field);
                    if (StringUtils.isNotBlank((CharSequence)fieldJavadoc)) {
                        ((Schema)stringSchemaEntry.getValue()).setDescription(fieldJavadoc);
                    }
                });
            });
        }
    }
}

