/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import jakarta.servlet.Filter;
import java.lang.reflect.Field;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiCustomizer;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnExpression(value="${springdoc.api-docs.enabled:true} and ${springdoc.enable-spring-security:true}")
@ConditionalOnClass(value={Authentication.class})
@ConditionalOnWebApplication
public class SpringDocSecurityConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDocSecurityConfiguration.class);

    static {
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(Authentication.class).addResponseTypeToIgnore(Authentication.class).addAnnotationsToIgnore(AuthenticationPrincipal.class);
    }

    @Lazy(value=false)
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Filter.class})
    class SpringSecurityLoginEndpointConfiguration {
        SpringSecurityLoginEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"springdoc.show-login-endpoint"})
        @Lazy(value=false)
        OpenApiCustomizer springSecurityLoginEndpointCustomiser(ApplicationContext applicationContext) {
            FilterChainProxy filterChainProxy = (FilterChainProxy)applicationContext.getBean("springSecurityFilterChain", FilterChainProxy.class);
            return openAPI -> {
                for (SecurityFilterChain filterChain : filterChainProxy.getFilterChains()) {
                    Optional<UsernamePasswordAuthenticationFilter> optionalFilter = filterChain.getFilters().stream().filter(UsernamePasswordAuthenticationFilter.class::isInstance).map(UsernamePasswordAuthenticationFilter.class::cast).findAny();
                    if (!optionalFilter.isPresent()) continue;
                    UsernamePasswordAuthenticationFilter usernamePasswordAuthenticationFilter = optionalFilter.get();
                    Operation operation = new Operation();
                    Schema schema = new ObjectSchema().addProperties(usernamePasswordAuthenticationFilter.getUsernameParameter(), (Schema)new StringSchema()).addProperties(usernamePasswordAuthenticationFilter.getPasswordParameter(), (Schema)new StringSchema());
                    RequestBody requestBody = new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(schema)));
                    operation.requestBody(requestBody);
                    ApiResponses apiResponses = new ApiResponses();
                    apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), new ApiResponse().description(HttpStatus.OK.getReasonPhrase()));
                    apiResponses.addApiResponse(String.valueOf(HttpStatus.FORBIDDEN.value()), new ApiResponse().description(HttpStatus.FORBIDDEN.getReasonPhrase()));
                    operation.responses(apiResponses);
                    operation.addTagsItem("login-endpoint");
                    PathItem pathItem = new PathItem().post(operation);
                    try {
                        Field requestMatcherField = AbstractAuthenticationProcessingFilter.class.getDeclaredField("requiresAuthenticationRequestMatcher");
                        requestMatcherField.setAccessible(true);
                        AntPathRequestMatcher requestMatcher = (AntPathRequestMatcher)requestMatcherField.get(usernamePasswordAuthenticationFilter);
                        String loginPath = requestMatcher.getPattern();
                        requestMatcherField.setAccessible(false);
                        openAPI.getPaths().addPathItem(loginPath, pathItem);
                    }
                    catch (ClassCastException | IllegalAccessException | NoSuchFieldException ignored) {
                        LOGGER.trace(ignored.getMessage());
                    }
                }
            };
        }
    }
}

