/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class PropertyResolverUtils {
    private final ConfigurableBeanFactory factory;
    private final MessageSource messageSource;
    private final SpringDocConfigProperties springDocConfigProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyResolverUtils.class);

    public PropertyResolverUtils(ConfigurableBeanFactory factory, MessageSource messageSource, SpringDocConfigProperties springDocConfigProperties) {
        this.factory = factory;
        this.messageSource = messageSource;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public String resolve(String parameterProperty, Locale locale) {
        if (!this.springDocConfigProperties.isDisableI18n()) {
            try {
                return this.messageSource.getMessage(parameterProperty, null, locale);
            }
            catch (NoSuchMessageException ex) {
                LOGGER.trace(ex.getMessage());
            }
        }
        try {
            return this.factory.resolveEmbeddedValue(parameterProperty);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(ex.getMessage());
            return parameterProperty;
        }
    }

    public ConfigurableBeanFactory getFactory() {
        return this.factory;
    }
}

