/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.security.SecuritySchemes;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.service.SecuritySchemePair;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

public class OpenAPIService
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIService.class);
    private ApplicationContext context;
    private final SecurityService securityParser;
    private final Map<String, Object> mappingsMap = new HashMap<String, Object>();
    private final Map<HandlerMethod, io.swagger.v3.oas.models.tags.Tag> springdocTags = new HashMap<HandlerMethod, io.swagger.v3.oas.models.tags.Tag>();
    private final Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers;
    private final SpringDocConfigProperties springDocConfigProperties;
    private OpenAPI openAPI;
    private final Map<String, OpenAPI> cachedOpenAPI = new HashMap<String, OpenAPI>();
    private OpenAPI calculatedOpenAPI;
    private boolean isServersPresent;
    private String serverBaseUrl;
    private PropertyResolverUtils propertyResolverUtils;
    private static Class<?> basicErrorController;

    public OpenAPIService(Optional<OpenAPI> openAPI, SecurityService securityParser, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> openApiBuilderCustomisers) {
        if (openAPI.isPresent()) {
            this.openAPI = openAPI.get();
            if (this.openAPI.getComponents() == null) {
                this.openAPI.setComponents(new Components());
            }
            if (this.openAPI.getPaths() == null) {
                this.openAPI.setPaths(new Paths());
            }
            if (!CollectionUtils.isEmpty((Collection)this.openAPI.getServers())) {
                this.isServersPresent = true;
            }
        }
        this.propertyResolverUtils = propertyResolverUtils;
        this.securityParser = securityParser;
        this.springDocConfigProperties = springDocConfigProperties;
        this.openApiBuilderCustomisers = openApiBuilderCustomisers;
        if (springDocConfigProperties.isUseFqn()) {
            TypeNameResolver.std.setUseFqn(true);
        }
    }

    public static String splitCamelCase(String str) {
        return str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "-").toLowerCase(Locale.ROOT);
    }

    public void build(Locale locale) {
        Optional<OpenAPIDefinition> apiDef = this.getOpenAPIDefinition();
        if (this.openAPI == null) {
            this.calculatedOpenAPI = new OpenAPI();
            this.calculatedOpenAPI.setComponents(new Components());
            this.calculatedOpenAPI.setPaths(new Paths());
        } else {
            try {
                this.calculatedOpenAPI = (OpenAPI)Json.mapper().readValue(Json.mapper().writeValueAsString((Object)this.openAPI), OpenAPI.class);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Json Processing Exception occurred: {}", (Object)e.getMessage());
            }
        }
        if (apiDef.isPresent()) {
            this.buildOpenAPIWithOpenAPIDefinition(this.calculatedOpenAPI, apiDef.get(), locale);
        } else if (this.calculatedOpenAPI.getInfo() == null) {
            io.swagger.v3.oas.models.info.Info infos = new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
            this.calculatedOpenAPI.setInfo(infos);
        }
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RestController.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RequestMapping.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(Controller.class));
        this.initializeHiddenRestController();
        this.calculateSecuritySchemes(this.calculatedOpenAPI.getComponents(), locale);
        this.openApiBuilderCustomisers.ifPresent(customisers -> customisers.forEach(customiser -> customiser.customise(this)));
    }

    private void initializeHiddenRestController() {
        List<Class> hiddenRestControllers;
        if (basicErrorController != null) {
            SpringDocUtils.getConfig().addHiddenRestControllers(basicErrorController);
        }
        if (!CollectionUtils.isEmpty(hiddenRestControllers = this.mappingsMap.entrySet().parallelStream().filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) != null).map(controller -> controller.getValue().getClass()).collect(Collectors.toList()))) {
            SpringDocUtils.getConfig().addHiddenRestControllers(hiddenRestControllers.toArray(new Class[hiddenRestControllers.size()]));
        }
    }

    public OpenAPI updateServers(OpenAPI openAPI) {
        if (!this.isServersPresent && this.serverBaseUrl != null) {
            io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server().url(this.serverBaseUrl).description("Generated server url");
            ArrayList<io.swagger.v3.oas.models.servers.Server> servers = new ArrayList<io.swagger.v3.oas.models.servers.Server>();
            servers.add(server);
            openAPI.setServers(servers);
        }
        return openAPI;
    }

    public void setServersPresent(boolean serversPresent) {
        this.isServersPresent = serversPresent;
    }

    public Operation buildTags(HandlerMethod handlerMethod, Operation operation, OpenAPI openAPI, Locale locale) {
        SecurityRequirement[] securityRequirements;
        HashSet<io.swagger.v3.oas.models.tags.Tag> tags = new HashSet<io.swagger.v3.oas.models.tags.Tag>();
        Set<String> tagsStr = new HashSet<String>();
        this.buildTagsFromClass(handlerMethod.getBeanType(), tags, tagsStr, locale);
        this.buildTagsFromMethod(handlerMethod.getMethod(), tags, tagsStr, locale);
        if (!CollectionUtils.isEmpty(tagsStr)) {
            tagsStr = tagsStr.stream().map(str -> this.propertyResolverUtils.resolve((String)str, locale)).collect(Collectors.toSet());
        }
        if (this.springdocTags.containsKey(handlerMethod)) {
            io.swagger.v3.oas.models.tags.Tag tag = this.springdocTags.get(handlerMethod);
            tagsStr.add(tag.getName());
            if (openAPI.getTags() == null || !openAPI.getTags().contains(tag)) {
                openAPI.addTagsItem(tag);
            }
        }
        if (!CollectionUtils.isEmpty(tagsStr)) {
            if (CollectionUtils.isEmpty((Collection)operation.getTags())) {
                operation.setTags(new ArrayList<String>(tagsStr));
            } else {
                HashSet<String> operationTagsSet = new HashSet<String>(operation.getTags());
                operationTagsSet.addAll(tagsStr);
                operation.getTags().clear();
                operation.getTags().addAll(operationTagsSet);
            }
        }
        if (this.isAutoTagClasses(operation)) {
            operation.addTagsItem(OpenAPIService.splitCamelCase(handlerMethod.getBeanType().getSimpleName()));
        }
        if (!CollectionUtils.isEmpty(tags)) {
            List openApiTags = openAPI.getTags();
            if (!CollectionUtils.isEmpty((Collection)openApiTags)) {
                tags.addAll(openApiTags);
            }
            openAPI.setTags(new ArrayList<io.swagger.v3.oas.models.tags.Tag>(tags));
        }
        if ((securityRequirements = this.securityParser.getSecurityRequirements(handlerMethod)) != null) {
            if (securityRequirements.length == 0) {
                operation.setSecurity(Collections.emptyList());
            } else {
                this.securityParser.buildSecurityRequirement(securityRequirements, operation);
            }
        }
        return operation;
    }

    private void buildTagsFromMethod(Method method, Set<io.swagger.v3.oas.models.tags.Tag> tags, Set<String> tagsStr, Locale locale) {
        Set tagsSet = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Tags.class);
        Set methodTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        methodTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Tag.class));
        if (!CollectionUtils.isEmpty(methodTags)) {
            tagsStr.addAll(methodTags.stream().map(tag -> this.propertyResolverUtils.resolve(tag.name(), locale)).collect(Collectors.toSet()));
            ArrayList<Tag> allTags = new ArrayList<Tag>(methodTags);
            this.addTags(allTags, tags, locale);
        }
    }

    private void addTags(List<Tag> sourceTags, Set<io.swagger.v3.oas.models.tags.Tag> tags, Locale locale) {
        Optional optionalTagSet = AnnotationsUtils.getTags((Tag[])sourceTags.toArray(new Tag[0]), (boolean)false);
        optionalTagSet.ifPresent(tagsSet -> {
            tagsSet.forEach(tag -> {
                tag.name(this.propertyResolverUtils.resolve(tag.getName(), locale));
                tag.description(this.propertyResolverUtils.resolve(tag.getDescription(), locale));
            });
            tags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tagsSet);
        });
    }

    public void buildTagsFromClass(Class<?> beanType, Set<io.swagger.v3.oas.models.tags.Tag> tags, Set<String> tagsStr, Locale locale) {
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        Set tagsSet = AnnotatedElementUtils.findAllMergedAnnotations(beanType, Tags.class);
        Set classTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        classTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations(beanType, Tag.class));
        if (!CollectionUtils.isEmpty(classTags)) {
            tagsStr.addAll(classTags.stream().map(tag -> this.propertyResolverUtils.resolve(tag.name(), locale)).collect(Collectors.toSet()));
            allTags.addAll(classTags);
            this.addTags(allTags, tags, locale);
        }
    }

    public Schema resolveProperties(Schema schema, Locale locale) {
        this.resolveProperty(() -> ((Schema)schema).getName(), arg_0 -> ((Schema)schema).name(arg_0), this.propertyResolverUtils, locale);
        this.resolveProperty(() -> ((Schema)schema).getTitle(), arg_0 -> ((Schema)schema).title(arg_0), this.propertyResolverUtils, locale);
        this.resolveProperty(() -> ((Schema)schema).getDescription(), arg_0 -> ((Schema)schema).description(arg_0), this.propertyResolverUtils, locale);
        Map properties = schema.getProperties();
        if (!CollectionUtils.isEmpty((Map)properties)) {
            LinkedHashMap resolvedSchemas = properties.entrySet().stream().map(es -> {
                es.setValue(this.resolveProperties((Schema)es.getValue(), locale));
                return es;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
            schema.setProperties((Map)resolvedSchemas);
        }
        return schema;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    private Optional<OpenAPIDefinition> getOpenAPIDefinition() {
        Map openAPIDefinitionMap = this.context.getBeansWithAnnotation(OpenAPIDefinition.class);
        OpenAPIDefinition apiDef = null;
        if (openAPIDefinitionMap.size() > 1) {
            LOGGER.warn("found more than one OpenAPIDefinition class. springdoc-openapi will be using the first one found.");
        }
        if (openAPIDefinitionMap.size() > 0) {
            Map.Entry entry = openAPIDefinitionMap.entrySet().iterator().next();
            Class<?> objClz = entry.getValue().getClass();
            apiDef = (OpenAPIDefinition)AnnotatedElementUtils.findMergedAnnotation(objClz, OpenAPIDefinition.class);
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                apiDef = this.getApiDefClass(scanner, packagesToScan);
            }
        }
        return Optional.ofNullable(apiDef);
    }

    private void buildOpenAPIWithOpenAPIDefinition(OpenAPI openAPI, OpenAPIDefinition apiDef, Locale locale) {
        AnnotationsUtils.getInfo((Info)apiDef.info()).map(info -> this.resolveProperties((io.swagger.v3.oas.models.info.Info)info, locale)).ifPresent(arg_0 -> ((OpenAPI)openAPI).setInfo(arg_0));
        this.securityParser.getSecurityRequirements(apiDef.security()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setSecurity(arg_0));
        AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiDef.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setExternalDocs(arg_0));
        AnnotationsUtils.getTags((Tag[])apiDef.tags(), (boolean)false).ifPresent(tags -> openAPI.setTags(new ArrayList(tags)));
        Optional optionalServers = AnnotationsUtils.getServers((Server[])apiDef.servers());
        optionalServers.map(servers -> this.resolveProperties((List<io.swagger.v3.oas.models.servers.Server>)servers, locale)).ifPresent(servers -> {
            this.isServersPresent = true;
            openAPI.servers(servers);
        });
        if (apiDef.extensions().length > 0) {
            openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])apiDef.extensions()));
        }
    }

    private List<io.swagger.v3.oas.models.servers.Server> resolveProperties(List<io.swagger.v3.oas.models.servers.Server> servers, Locale locale) {
        servers.forEach(server -> {
            this.resolveProperty(() -> ((io.swagger.v3.oas.models.servers.Server)server).getUrl(), arg_0 -> ((io.swagger.v3.oas.models.servers.Server)server).url(arg_0), this.propertyResolverUtils, locale);
            this.resolveProperty(() -> ((io.swagger.v3.oas.models.servers.Server)server).getDescription(), arg_0 -> ((io.swagger.v3.oas.models.servers.Server)server).description(arg_0), this.propertyResolverUtils, locale);
            if (CollectionUtils.isEmpty((Map)server.getVariables())) {
                server.setVariables(null);
            }
        });
        return servers;
    }

    private io.swagger.v3.oas.models.info.Info resolveProperties(io.swagger.v3.oas.models.info.Info info, Locale locale) {
        Contact contact;
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getTitle(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).title(arg_0), this.propertyResolverUtils, locale);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getDescription(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).description(arg_0), this.propertyResolverUtils, locale);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getVersion(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).version(arg_0), this.propertyResolverUtils, locale);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getTermsOfService(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).termsOfService(arg_0), this.propertyResolverUtils, locale);
        License license = info.getLicense();
        if (license != null) {
            this.resolveProperty(() -> ((License)license).getName(), arg_0 -> ((License)license).name(arg_0), this.propertyResolverUtils, locale);
            this.resolveProperty(() -> ((License)license).getUrl(), arg_0 -> ((License)license).url(arg_0), this.propertyResolverUtils, locale);
        }
        if ((contact = info.getContact()) != null) {
            this.resolveProperty(() -> ((Contact)contact).getName(), arg_0 -> ((Contact)contact).name(arg_0), this.propertyResolverUtils, locale);
            this.resolveProperty(() -> ((Contact)contact).getEmail(), arg_0 -> ((Contact)contact).email(arg_0), this.propertyResolverUtils, locale);
            this.resolveProperty(() -> ((Contact)contact).getUrl(), arg_0 -> ((Contact)contact).url(arg_0), this.propertyResolverUtils, locale);
        }
        return info;
    }

    private void resolveProperty(Supplier<String> getProperty, Consumer<String> setProperty, PropertyResolverUtils propertyResolverUtils, Locale locale) {
        String value = getProperty.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            setProperty.accept(propertyResolverUtils.resolve(value, locale));
        }
    }

    private void calculateSecuritySchemes(Components components, Locale locale) {
        Map securitySchemeBeans = this.context.getBeansWithAnnotation(SecurityScheme.class);
        if (securitySchemeBeans.size() > 0) {
            for (Map.Entry entry : securitySchemeBeans.entrySet()) {
                Class<?> objClz = entry.getValue().getClass();
                Set apiSecurityScheme = AnnotatedElementUtils.findMergedRepeatableAnnotations(objClz, SecurityScheme.class);
                this.addSecurityScheme(apiSecurityScheme, components, locale);
            }
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SecuritySchemes.class));
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SecurityScheme.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                Set<SecurityScheme> apiSecurityScheme = this.getSecuritySchemesClasses(scanner, packagesToScan);
                this.addSecurityScheme(apiSecurityScheme, components, locale);
            }
        }
    }

    private void addSecurityScheme(Set<SecurityScheme> apiSecurityScheme, Components components, Locale locale) {
        for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
            Optional<SecuritySchemePair> securityScheme = this.securityParser.getSecurityScheme(securitySchemeAnnotation, locale);
            if (!securityScheme.isPresent()) continue;
            HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
            if (!StringUtils.isNotBlank((CharSequence)securityScheme.get().key())) continue;
            securitySchemeMap.put(securityScheme.get().key(), securityScheme.get().securityScheme());
            if (!CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
                components.getSecuritySchemes().putAll(securitySchemeMap);
                continue;
            }
            components.setSecuritySchemes(securitySchemeMap);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    public boolean isAutoTagClasses(Operation operation) {
        return CollectionUtils.isEmpty((Collection)operation.getTags()) && this.springDocConfigProperties.isAutoTagClasses();
    }

    private Set<SecurityScheme> getSecuritySchemesClasses(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        HashSet<SecurityScheme> apiSecurityScheme = new HashSet<SecurityScheme>();
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    apiSecurityScheme.add((SecurityScheme)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecurityScheme.class));
                    SecuritySchemes apiSecuritySchemes = (SecuritySchemes)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecuritySchemes.class);
                    if (apiSecuritySchemes == null || ArrayUtils.isEmpty((Object[])apiSecuritySchemes.value())) continue;
                    Arrays.stream(apiSecuritySchemes.value()).forEach(apiSecurityScheme::add);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return apiSecurityScheme;
    }

    public void addTag(Set<HandlerMethod> handlerMethods, io.swagger.v3.oas.models.tags.Tag tag) {
        handlerMethods.forEach(handlerMethod -> this.springdocTags.put((HandlerMethod)handlerMethod, tag));
    }

    public Map<String, Object> getMappingsMap() {
        return this.mappingsMap;
    }

    public void addMappings(Map<String, Object> mappings) {
        this.mappingsMap.putAll(mappings);
    }

    public Map<String, Object> getControllerAdviceMap() {
        Map controllerAdviceMap = this.context.getBeansWithAnnotation(ControllerAdvice.class);
        return Stream.of(controllerAdviceMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1, LinkedHashMap::new));
    }

    public OpenAPI getCachedOpenAPI(Locale locale) {
        return this.cachedOpenAPI.get(locale.toLanguageTag());
    }

    public void setCachedOpenAPI(OpenAPI cachedOpenAPI, Locale locale) {
        this.cachedOpenAPI.put(locale.toLanguageTag(), cachedOpenAPI);
    }

    public OpenAPI getCalculatedOpenAPI() {
        return this.calculatedOpenAPI;
    }

    public void resetCalculatedOpenAPI() {
        this.calculatedOpenAPI = null;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public SecurityService getSecurityParser() {
        return this.securityParser;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    static {
        try {
            basicErrorController = Class.forName("org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController");
        }
        catch (ClassNotFoundException e) {
            try {
                basicErrorController = Class.forName("org.springframework.boot.autoconfigure.web.BasicErrorController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.trace(classNotFoundException.getMessage());
            }
        }
    }
}

