/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.gradle.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.kotlin.AwaitilityKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.openapi.gradle.plugin.OpenApiExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiDocsUrl", "Lorg/gradle/api/provider/Property;", "", "getApiDocsUrl", "()Lorg/gradle/api/provider/Property;", "groupedApiMappings", "Lorg/gradle/api/provider/MapProperty;", "getGroupedApiMappings", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFileName", "getOutputFileName", "waitTimeInSeconds", "", "getWaitTimeInSeconds", "execute", "", "generateApiDocs", "url", "fileName", "prettifyJson", "response", "springdoc-openapi-gradle-plugin"})
public class OpenApiGeneratorTask
extends DefaultTask {
    @NotNull
    private final Property<String> apiDocsUrl;
    @NotNull
    private final Property<String> outputFileName;
    @NotNull
    private final MapProperty<String, String> groupedApiMappings;
    @NotNull
    private final DirectoryProperty outputDir;
    @NotNull
    private final Property<Integer> waitTimeInSeconds;

    public OpenApiGeneratorTask() {
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.apiDocsUrl = property;
        Property property2 = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(String::class.java)");
        this.outputFileName = property2;
        MapProperty mapProperty = this.getProject().getObjects().mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"project.objects.mapPrope\u2026java, String::class.java)");
        this.groupedApiMappings = mapProperty;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDir = directoryProperty;
        Property property3 = this.getProject().getObjects().property(Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property(Int::class.java)");
        this.waitTimeInSeconds = property3;
        this.setDescription("Generates the spring doc openapi file");
        this.setGroup("OpenApi");
        Object object = this.getProject().getExtensions().getByName("openApi");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springdoc.openapi.gradle.plugin.OpenApiExtension");
        OpenApiExtension extension = (OpenApiExtension)object;
        this.apiDocsUrl.convention((Provider)extension.getApiDocsUrl());
        this.outputFileName.convention((Provider)extension.getOutputFileName());
        this.groupedApiMappings.convention((Provider)extension.getGroupedApiMappings());
        this.outputDir.convention((Provider)extension.getOutputDir());
        this.waitTimeInSeconds.convention((Provider)extension.getWaitTimeInSeconds());
    }

    @Input
    @NotNull
    public final Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    @Input
    @NotNull
    public final Property<String> getOutputFileName() {
        return this.outputFileName;
    }

    @Input
    @NotNull
    public final MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @Internal
    @NotNull
    public final Property<Integer> getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public final void execute() {
        if (this.groupedApiMappings.isPresent()) {
            Object object = this.groupedApiMappings.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupedApiMappings.get()");
            if (!((Map)object).isEmpty()) {
                ((Map)this.groupedApiMappings.get()).forEach((arg_0, arg_1) -> OpenApiGeneratorTask.execute$lambda$0((Function2)new Function2<String, String, Unit>((Object)this){

                    public final void invoke(@NotNull String p0, @NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        OpenApiGeneratorTask.access$generateApiDocs((OpenApiGeneratorTask)((Object)this.receiver), p0, p1);
                    }
                }, arg_0, arg_1));
                return;
            }
        }
        Object object = this.apiDocsUrl.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiDocsUrl.get()");
        String string = (String)object;
        Object object2 = this.outputFileName.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputFileName.get()");
        this.generateApiDocs(string, (String)object2);
    }

    private final void generateApiDocs(String url, String fileName) {
        try {
            String string = url.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            CharSequence charSequence = string;
            boolean isYaml = new Regex(".+[./]yaml(/.+)*").matches(charSequence);
            ConditionFactory conditionFactory = AwaitilityKt.ignoreException((ConditionFactory)AwaitilityKt.getAwait(), (KClass)Reflection.getOrCreateKotlinClass(ConnectException.class));
            Duration duration = Durations.ONE_SECOND;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ONE_SECOND");
            ConditionFactory conditionFactory2 = AwaitilityKt.withPollInterval((ConditionFactory)conditionFactory, (Duration)duration);
            Duration duration2 = Duration.of(((Number)this.waitTimeInSeconds.get()).intValue(), ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"of(\n\t\t\t\twaitTimeInSecond\u2026oLong(),\n\t\t\t\tSECONDS\n\t\t\t)");
            AwaitilityKt.until((ConditionFactory)AwaitilityKt.atMost((ConditionFactory)conditionFactory2, (Duration)duration2), (Function0)((Function0)new Function0<Boolean>(url, this){
                final /* synthetic */ String $url;
                final /* synthetic */ OpenApiGeneratorTask this$0;
                {
                    this.$url = $url;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    URLConnection uRLConnection = new URL(this.$url).openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                    connection.setRequestMethod("GET");
                    connection.connect();
                    int statusCode = connection.getResponseCode();
                    this.this$0.getLogger().trace("apiDocsUrl = {} status code = {}", (Object)this.$url, (Object)statusCode);
                    return statusCode < 299;
                }
            }));
            this.getLogger().info("Generating OpenApi Docs..");
            URLConnection uRLConnection = new URL(url).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            Charset charset = Charsets.UTF_8;
            String response = new String(byArray, charset);
            String apiDocs = isYaml ? response : this.prettifyJson(response);
            File outputFile = ((RegularFile)this.outputDir.file(fileName).get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
            FilesKt.writeText$default((File)outputFile, (String)apiDocs, null, (int)2, null);
        }
        catch (ConditionTimeoutException e) {
            this.getLogger().error("Unable to connect to " + url + " waited for " + this.waitTimeInSeconds.get() + " seconds", (Throwable)e);
            throw new GradleException("Unable to connect to " + url + " waited for " + this.waitTimeInSeconds.get() + " seconds");
        }
    }

    private final String prettifyJson(String response) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            JsonObject googleJsonObject = (JsonObject)gson.fromJson(response, JsonObject.class);
            String string = gson.toJson((JsonElement)googleJsonObject);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(googleJsonObject)");
            return string;
        }
        catch (RuntimeException e) {
            throw new JsonSyntaxException("Failed to parse the API docs response string. Please ensure that the response is in the correct format. response=" + response, (Throwable)e);
        }
    }

    private static final void execute$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$generateApiDocs(OpenApiGeneratorTask $this, String url, String fileName) {
        $this.generateApiDocs(url, fileName);
    }
}

