/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.gradle.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.ConnectException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import khttp.KHttp;
import khttp.responses.Response;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.kotlin.AwaitilityKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.openapi.gradle.plugin.OpenApiExtension;
import org.springdoc.openapi.gradle.plugin.OpenApiGeneratorTaskKt$sam$java_util_function_BiConsumer$0;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiDocsUrl", "Lorg/gradle/api/provider/Property;", "", "getApiDocsUrl", "()Lorg/gradle/api/provider/Property;", "groupedApiMappings", "Lorg/gradle/api/provider/MapProperty;", "getGroupedApiMappings", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFileName", "getOutputFileName", "waitTimeInSeconds", "", "execute", "", "generateApiDocs", "url", "fileName", "prettifyJson", "response", "Lkhttp/responses/Response;", "springdoc-openapi-gradle-plugin"})
public class OpenApiGeneratorTask
extends DefaultTask {
    @NotNull
    private final Property<String> apiDocsUrl;
    @NotNull
    private final Property<String> outputFileName;
    @NotNull
    private final MapProperty<String, String> groupedApiMappings;
    @NotNull
    private final DirectoryProperty outputDir;
    private final Property<Integer> waitTimeInSeconds;

    @Input
    @NotNull
    public final Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    @Input
    @NotNull
    public final Property<String> getOutputFileName() {
        return this.outputFileName;
    }

    @Input
    @NotNull
    public final MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public final void execute() {
        if (this.groupedApiMappings.isPresent()) {
            Object object = this.groupedApiMappings.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupedApiMappings.get()");
            Map map = (Map)object;
            boolean bl = false;
            if (!map.isEmpty()) {
                map = (Function2)new Function2<String, String, Unit>(this){

                    public final void invoke(@NotNull String p1, @NotNull String p2) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        OpenApiGeneratorTask.access$generateApiDocs((OpenApiGeneratorTask)((Object)this.receiver), p1, p2);
                    }
                };
                ((Map)this.groupedApiMappings.get()).forEach(new OpenApiGeneratorTaskKt$sam$java_util_function_BiConsumer$0((Function2)map));
                return;
            }
        }
        Object object = this.apiDocsUrl.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiDocsUrl.get()");
        String string = (String)object;
        Object object2 = this.outputFileName.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputFileName.get()");
        this.generateApiDocs(string, (String)object2);
    }

    /*
     * Unable to fully structure code
     */
    private final void generateApiDocs(String url, String fileName) {
        try {
            v0 = AwaitilityKt.ignoreException((ConditionFactory)AwaitilityKt.getAwait(), (KClass)Reflection.getOrCreateKotlinClass(ConnectException.class));
            v1 = Durations.ONE_SECOND;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"Durations.ONE_SECOND");
            v2 = AwaitilityKt.withPollInterval((ConditionFactory)v0, (Duration)v1);
            v3 = Duration.of(((Number)this.waitTimeInSeconds.get()).intValue(), ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Duration.of(\n           \u2026    SECONDS\n            )");
            AwaitilityKt.until((ConditionFactory)AwaitilityKt.atMost((ConditionFactory)v2, (Duration)v3), (Function0)((Function0)new Function0<Boolean>(this, url){
                final /* synthetic */ OpenApiGeneratorTask this$0;
                final /* synthetic */ String $url;

                public final boolean invoke() {
                    int statusCode = KHttp.get$default((String)this.$url, null, null, null, null, null, null, (double)0.0, null, (boolean)false, null, (int)2046, null).getStatusCode();
                    this.this$0.getLogger().trace("apiDocsUrl = {} status code = {}", (Object)this.$url, (Object)statusCode);
                    return statusCode < 299;
                }
                {
                    this.this$0 = openApiGeneratorTask;
                    this.$url = string;
                    super(0);
                }
            }));
            this.getLogger().info("Generating OpenApi Docs..");
            response = KHttp.get$default((String)url, null, null, null, null, null, null, (double)0.0, null, (boolean)false, null, (int)2046, null);
            var5_5 = url;
            var6_6 = false;
            v4 = var5_5;
            if (v4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v5 = v4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.contains$default((CharSequence)v5, (CharSequence)".yaml", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            var5_5 = url;
            var6_6 = false;
            v6 = var5_5;
            if (v6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v7 = v6.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.endsWith$default((String)v7, (String)"/yaml", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v8 = true;
            } else {
                v8 = false;
            }
            isYaml = v8;
            apiDocs = isYaml != false ? response.getText() : this.prettifyJson(response);
            v9 = this.outputDir.file(fileName).get();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"outputDir.file(fileName).get()");
            v10 = outputFile = ((RegularFile)v9).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"outputFile");
            FilesKt.writeText$default((File)v10, (String)apiDocs, null, (int)2, null);
        }
        catch (ConditionTimeoutException e) {
            this.getLogger().error("Unable to connect to " + url + " waited for " + (Integer)this.waitTimeInSeconds.get() + " seconds", (Throwable)e);
            throw (Throwable)new GradleException("Unable to connect to " + url + " waited for " + (Integer)this.waitTimeInSeconds.get() + " seconds");
        }
    }

    private final String prettifyJson(Response response) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject googleJsonObject = (JsonObject)gson.fromJson(response.getText(), JsonObject.class);
        String string = gson.toJson((JsonElement)googleJsonObject);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(googleJsonObject)");
        return string;
    }

    public OpenApiGeneratorTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Property property = project.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.apiDocsUrl = property;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Property property2 = project2.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(String::class.java)");
        this.outputFileName = property2;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        MapProperty mapProperty = project3.getObjects().mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"project.objects.mapPrope\u2026java, String::class.java)");
        this.groupedApiMappings = mapProperty;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        DirectoryProperty directoryProperty = project4.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDir = directoryProperty;
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        Property property3 = project5.getObjects().property(Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property(Int::class.java)");
        this.waitTimeInSeconds = property3;
        this.setDescription("Generates the spring doc openapi file");
        this.setGroup("OpenApi");
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        ExtensionContainer extensionContainer = project6.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$run = extensionContainer;
        boolean bl3 = false;
        Object object = $this$run.getByName("openApi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.springdoc.openapi.gradle.plugin.OpenApiExtension");
        }
        OpenApiExtension extension = (OpenApiExtension)object;
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
        DirectoryProperty defaultOutputDir = project7.getObjects().directoryProperty();
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
        defaultOutputDir.set(project8.getBuildDir());
        this.apiDocsUrl.set(extension.getApiDocsUrl().getOrElse((Object)"http://localhost:8080/v3/api-docs"));
        this.outputFileName.set(extension.getOutputFileName().getOrElse((Object)"openapi.json"));
        this.groupedApiMappings.set((Map)extension.getGroupedApiMappings().getOrElse((Object)MapsKt.emptyMap()));
        this.outputDir.set(extension.getOutputDir().getOrElse(defaultOutputDir.get()));
        this.waitTimeInSeconds.set(extension.getWaitTimeInSeconds().getOrElse((Object)30));
    }

    public static final /* synthetic */ void access$generateApiDocs(OpenApiGeneratorTask $this, String url, String fileName) {
        $this.generateApiDocs(url, fileName);
    }
}

