/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.gradle.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.ConnectException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import khttp.KHttp;
import khttp.responses.Response;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.kotlin.AwaitilityKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.openapi.gradle.plugin.OpenApiExtension;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiDocsUrl", "Lorg/gradle/api/provider/Property;", "", "getApiDocsUrl", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFileName", "getOutputFileName", "waitTimeInSeconds", "", "execute", "", "prettifyJson", "response", "Lkhttp/responses/Response;", "springdoc-openapi-gradle-plugin"})
public class OpenApiGeneratorTask
extends DefaultTask {
    @NotNull
    private final Property<String> apiDocsUrl;
    @NotNull
    private final Property<String> outputFileName;
    @NotNull
    private final DirectoryProperty outputDir;
    private final Property<Integer> waitTimeInSeconds;

    @Input
    @NotNull
    public final Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    @Input
    @NotNull
    public final Property<String> getOutputFileName() {
        return this.outputFileName;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @TaskAction
    public final void execute() {
        try {
            File outputFile;
            ConditionFactory conditionFactory = AwaitilityKt.ignoreException((ConditionFactory)AwaitilityKt.getAwait(), (KClass)Reflection.getOrCreateKotlinClass(ConnectException.class));
            Duration duration = Durations.ONE_SECOND;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Durations.ONE_SECOND");
            ConditionFactory conditionFactory2 = AwaitilityKt.withPollInterval((ConditionFactory)conditionFactory, (Duration)duration);
            Duration duration2 = Duration.of(((Number)this.waitTimeInSeconds.get()).intValue(), ChronoUnit.SECONDS);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.of(\n           \u2026    SECONDS\n            )");
            AwaitilityKt.until((ConditionFactory)AwaitilityKt.atMost((ConditionFactory)conditionFactory2, (Duration)duration2), (Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ OpenApiGeneratorTask this$0;

                public final boolean invoke() {
                    Object object = this.this$0.getApiDocsUrl().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apiDocsUrl.get()");
                    int statusCode = KHttp.get$default((String)((String)object), null, null, null, null, null, null, (double)0.0, null, (boolean)false, null, (int)2046, null).getStatusCode();
                    this.this$0.getLogger().trace("apiDocsUrl = {} status code = {}", this.this$0.getApiDocsUrl().get(), (Object)statusCode);
                    return statusCode < 299;
                }
                {
                    this.this$0 = openApiGeneratorTask;
                    super(0);
                }
            }));
            this.getLogger().info("Generating OpenApi Docs..");
            Object object = this.apiDocsUrl.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apiDocsUrl.get()");
            Response response = KHttp.get$default((String)((String)object), null, null, null, null, null, null, (double)0.0, null, (boolean)false, null, (int)2046, null);
            Object object2 = this.apiDocsUrl.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"apiDocsUrl.get()");
            String string = (String)object2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            boolean isYaml = StringsKt.endsWith$default((String)string3, (String)".yaml", (boolean)false, (int)2, null);
            String apiDocs = isYaml ? response.getText() : this.prettifyJson(response);
            Object object3 = this.outputDir.file((String)this.outputFileName.get()).get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"outputDir.file(outputFileName.get()).get()");
            File file = outputFile = ((RegularFile)object3).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile");
            FilesKt.writeText$default((File)file, (String)apiDocs, null, (int)2, null);
        }
        catch (ConditionTimeoutException e) {
            this.getLogger().error("Unable to connect to " + (String)this.apiDocsUrl.get() + " waited for " + (Integer)this.waitTimeInSeconds.get() + " seconds", (Throwable)e);
            throw (Throwable)new GradleException("Unable to connect to " + (String)this.apiDocsUrl.get() + " waited for " + (Integer)this.waitTimeInSeconds.get() + " seconds");
        }
    }

    private final String prettifyJson(Response response) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject googleJsonObject = (JsonObject)gson.fromJson(response.getJsonObject().toString(), JsonObject.class);
        String string = gson.toJson((JsonElement)googleJsonObject);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(googleJsonObject)");
        return string;
    }

    public OpenApiGeneratorTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Property property = project.getObjects().property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"project.objects.property(String::class.java)");
        this.apiDocsUrl = property;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Property property2 = project2.getObjects().property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"project.objects.property(String::class.java)");
        this.outputFileName = property2;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        DirectoryProperty directoryProperty = project3.getObjects().directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDir = directoryProperty;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        Property property3 = project4.getObjects().property(Integer.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"project.objects.property(Int::class.java)");
        this.waitTimeInSeconds = property3;
        this.setDescription("Generates the spring doc openapi file");
        this.setGroup("OpenApi");
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        ExtensionContainer extensionContainer = project5.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$run = extensionContainer;
        boolean bl3 = false;
        Object object = $this$run.getByName("openApi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.springdoc.openapi.gradle.plugin.OpenApiExtension");
        }
        OpenApiExtension extension = (OpenApiExtension)object;
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        DirectoryProperty defaultOutputDir = project6.getObjects().directoryProperty();
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        defaultOutputDir.set(project7.getBuildDir());
        this.apiDocsUrl.set(extension.getApiDocsUrl().getOrElse((Object)"http://localhost:8080/v3/api-docs"));
        this.outputFileName.set(extension.getOutputFileName().getOrElse((Object)"openapi.json"));
        this.outputDir.set(extension.getOutputDir().getOrElse(defaultOutputDir.get()));
        this.waitTimeInSeconds.set(extension.getWaitTimeInSeconds().getOrElse((Object)30));
    }
}

