/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.data.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.hateoas.HateoasHalProvider;
import org.springframework.boot.autoconfigure.hateoas.HateoasProperties;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;

public class DataRestHalProvider
extends HateoasHalProvider {
    private final Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional;

    public DataRestHalProvider(Optional<RepositoryRestConfiguration> repositoryRestConfigurationOptional, Optional<HateoasProperties> hateoasPropertiesOptional, ObjectMapperProvider objectMapperProvider) {
        super(hateoasPropertiesOptional, objectMapperProvider);
        this.repositoryRestConfigurationOptional = repositoryRestConfigurationOptional;
    }

    @PostConstruct
    protected void init() {
        if (!this.isHalEnabled()) {
            return;
        }
        if (!Jackson2HalModule.isAlreadyRegisteredIn((ObjectMapper)this.objectMapperProvider.jsonMapper())) {
            this.objectMapperProvider.jsonMapper().registerModule((Module)new Jackson2HalModule());
        }
    }

    public boolean isHalEnabled() {
        return this.repositoryRestConfigurationOptional.map(RepositoryRestConfiguration::useHalAsDefaultJsonMediaType).orElse(true);
    }
}

