/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springdoc.core.AbstractRequestBuilder;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RequestBuilder
extends AbstractRequestBuilder {
    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, String[] allConsumes) {
        operation.setOperationId(handlerMethod.getMethod().getName());
        LocalVariableTableParameterNameDiscoverer d = new LocalVariableTableParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        java.lang.reflect.Parameter[] parameters = handlerMethod.getMethod().getParameters();
        MethodUtils.getAnnotation((Method)handlerMethod.getMethod(), Parameter.class, (boolean)true, (boolean)true);
        for (int i = 0; i < pNames.length; ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = null;
            Class<?> paramType = parameters[i].getType();
            Parameter parameterDoc = (Parameter)this.getParameterAnnotation(handlerMethod, parameters[i], i, Parameter.class);
            if (parameterDoc != null) {
                if (parameterDoc.hidden()) continue;
                parameter = this.buildParameterFromDoc(parameterDoc);
            }
            if (this.isParamTypeToIgnore(paramType)) continue;
            parameter = this.buildParams(pNames[i], components, parameters[i], i, parameter, handlerMethod);
            if ((parameter = this.buildParamDefault(requestMethod, pNames[i], parameters[i], parameter)) != null && parameter.getName() != null) {
                this.applyBeanValidatorAnnotations(parameter, Arrays.asList(parameters[i].getAnnotations()));
                operationParameters.add(parameter);
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            RequestPart requestPart = (RequestPart)this.getParameterAnnotation(handlerMethod, parameters[i], i, RequestPart.class);
            String paramName = null;
            if (requestPart != null) {
                paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
            }
            paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)pNames[i]);
            RequestBody requestBody = this.buildRequestBody(components, allConsumes, parameters[i], parameterDoc, paramName);
            operation.setRequestBody(requestBody);
        }
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        return operation;
    }

    private boolean isParamTypeToIgnore(Class<?> paramType) {
        return WebRequest.class.equals(paramType) || NativeWebRequest.class.equals(paramType) || ServletRequest.class.equals(paramType) || ServletResponse.class.equals(paramType) || HttpSession.class.equals(paramType) || Principal.class.equals(paramType) || HttpMethod.class.equals(paramType) || Locale.class.equals(paramType) || TimeZone.class.equals(paramType) || ZoneId.class.equals(paramType) || InputStream.class.equals(paramType) || Reader.class.equals(paramType) || OutputStream.class.equals(paramType) || Writer.class.equals(paramType) || Map.class.equals(paramType) || Model.class.equals(paramType) || ModelMap.class.equals(paramType) || RedirectAttributes.class.equals(paramType) || Errors.class.equals(paramType) || BindingResult.class.equals(paramType) || SessionStatus.class.equals(paramType) || UriComponentsBuilder.class.equals(paramType);
    }
}

