/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.InfoBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.TagsBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiResource
extends AbstractOpenApiResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiResource.class);
    private RequestMappingInfoHandlerMapping requestMappingHandlerMapping;

    private OpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, TagsBuilder tagbuiBuilder, OperationBuilder operationParser, InfoBuilder infoBuilder, RequestMappingInfoHandlerMapping requestMappingHandlerMapping) {
        super(openAPIBuilder, requestBuilder, responseBuilder, tagbuiBuilder, operationParser, infoBuilder);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    private OpenAPI getOpenApi() {
        long start = System.currentTimeMillis();
        this.infoBuilder.build(this.openAPIBuilder.getOpenAPI());
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        Map findRestControllers1 = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(RestController.class);
        Map findRestControllers2 = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(RequestMapping.class);
        Map<String, Object> findRestControllers = Stream.of(findRestControllers1, findRestControllers2).flatMap(mapEl -> mapEl.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
        Map findControllerAdvice = this.requestMappingHandlerMapping.getApplicationContext().getBeansWithAnnotation(ControllerAdvice.class);
        this.responseBuilder.buildGenericResponse(this.openAPIBuilder.getComponents(), findControllerAdvice);
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            String operationPath = (String)patterns.iterator().next();
            if (!operationPath.startsWith("/") || !findRestControllers.containsKey(handlerMethod.getBean().toString())) continue;
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            this.calculatePath(this.openAPIBuilder, handlerMethod, operationPath, requestMethods);
        }
        this.openAPIBuilder.getOpenAPI().setPaths(this.openAPIBuilder.getPaths());
        LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)(System.currentTimeMillis() - start));
        return this.openAPIBuilder.getOpenAPI();
    }

    private void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        StringBuffer requestUrl = request.getRequestURL();
        String serverBaseUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.infoBuilder.setServerBaseUrl(serverBaseUrl);
    }
}

