/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AnnotationsUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

@Component
public class RequestBuilder {
    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, String[] allConsumes) {
        operation.setOperationId(handlerMethod.getMethod().getName());
        LocalVariableTableParameterNameDiscoverer d = new LocalVariableTableParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        Parameter[] parameters = handlerMethod.getMethod().getParameters();
        for (int i = 0; i < pNames.length; ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = null;
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)AnnotationUtils.findAnnotation((AnnotatedElement)parameters[i], io.swagger.v3.oas.annotations.Parameter.class);
            if (parameterDoc != null) {
                if (parameterDoc.hidden()) continue;
                parameter = this.buildParameterFromDoc(parameterDoc);
            }
            parameter = this.buildParams(components, parameters[i], parameter);
            if (RequestMethod.GET.equals((Object)requestMethod) && parameter == null) {
                String name = pNames[i];
                parameter = this.buildParam("query", null, parameters[i], Boolean.FALSE, name, null);
            }
            if (parameter != null && parameter.getName() != null) {
                this.applyBeanValidatorAnnotations(parameter, Arrays.asList(parameters[i].getAnnotations()));
                operationParameters.add(parameter);
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            RequestBody requestBody = this.buildRequestBody(components, allConsumes, parameters[i], parameterDoc);
            operation.setRequestBody(requestBody);
        }
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        return operation;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParams(Components components, Parameter parameters, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        RequestHeader requestHeader = (RequestHeader)AnnotationUtils.findAnnotation((AnnotatedElement)parameters, RequestHeader.class);
        RequestParam requestParam = (RequestParam)AnnotationUtils.findAnnotation((AnnotatedElement)parameters, RequestParam.class);
        PathVariable pathVar = (PathVariable)AnnotationUtils.findAnnotation((AnnotatedElement)parameters, PathVariable.class);
        if (requestHeader != null) {
            parameter = this.buildParam("header", components, parameters, requestHeader.required(), requestHeader.value(), parameter);
        } else if (requestParam != null) {
            parameter = this.buildParam("query", components, parameters, requestParam.required(), requestParam.value(), parameter);
        } else if (pathVar != null) {
            parameter = this.buildParam("path", components, parameters, Boolean.TRUE, pathVar.value(), parameter);
        }
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(String in, Components components, Parameter parameters, Boolean required, String name, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        }
        parameter.setIn(in);
        parameter.setRequired(required);
        parameter.setName(name);
        Schema<?> schema = this.calculateSchema(components, parameters);
        parameter.setSchema(schema);
        return parameter;
    }

    private RequestBody buildRequestBody(Components components, String[] allConsumes, Parameter parameter, io.swagger.v3.oas.annotations.Parameter parameterDoc) {
        RequestBody requestBody = new RequestBody();
        Schema<?> schema = this.calculateSchema(components, parameter);
        MediaType mediaType = null;
        if (schema != null && schema.getType() != null) {
            mediaType = new MediaType();
            mediaType.setSchema(schema);
        } else {
            Class<?> returnType = parameter.getType();
            mediaType = this.calculateSchema(components, returnType);
        }
        Content content1 = new Content();
        if (ArrayUtils.isNotEmpty((Object[])allConsumes)) {
            for (String value : allConsumes) {
                this.setMediaTypeToContent(schema, content1, value);
            }
        } else {
            content1.addMediaType("*/*", mediaType);
        }
        requestBody.setContent(content1);
        if (parameterDoc != null) {
            if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
                requestBody.setDescription(parameterDoc.description());
            }
            requestBody.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        return requestBody;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(io.swagger.v3.oas.annotations.Parameter parameterDoc) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(parameterDoc.description());
        } else if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setDescription(parameterDoc.name());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        }
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    private void setExamples(io.swagger.v3.oas.annotations.Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        HashMap exampleMap = new HashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = io.swagger.v3.core.util.AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            if (exampleOptional.isPresent()) {
                parameter.setExample(exampleOptional.get());
            }
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                io.swagger.v3.core.util.AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(io.swagger.v3.oas.annotations.Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = io.swagger.v3.core.util.AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions());
            for (Map.Entry entry : extensionMap.entrySet()) {
                parameter.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Schema<?> calculateSchema(Components components, Parameter parameter) {
        Schema schemaN = null;
        Type returnType = parameter.getParameterizedType();
        if (returnType instanceof ParameterizedType) {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
            if (resolvedSchema.schema != null) {
                schemaN = resolvedSchema.schema;
                Map schemaMap = resolvedSchema.referencedSchemas;
                if (schemaMap != null) {
                    schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
                }
            }
        } else {
            schemaN = AnnotationsUtils.resolveSchemaFromType(parameter.getType(), null, null);
        }
        return schemaN;
    }

    private MediaType calculateSchema(Components components, Type returnType) {
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
        MediaType mediaType = new MediaType();
        if (resolvedSchema.schema != null) {
            Map schemaMap;
            Schema returnTypeSchema = resolvedSchema.schema;
            if (returnTypeSchema != null) {
                mediaType.setSchema(returnTypeSchema);
            }
            if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return mediaType;
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, io.swagger.v3.oas.annotations.Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private boolean isExplodable(io.swagger.v3.oas.annotations.Parameter p) {
        Class implementation;
        io.swagger.v3.oas.annotations.media.Schema schema = p.schema();
        boolean explode = true;
        if (schema != null && (implementation = schema.implementation()) == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, io.swagger.v3.oas.annotations.Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap annos = new HashMap();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), annotation));
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            schema.setMinimum(BigDecimal.valueOf(size.min()));
            schema.setMaximum(BigDecimal.valueOf(size.max()));
            schema.setMinItems(Integer.valueOf(size.min()));
            schema.setMaxItems(Integer.valueOf(size.max()));
        }
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.valueOf(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.valueOf(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }
}

