/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SecurityParser {
    private SecurityParser() {
    }

    public static Optional<List<SecurityRequirement>> getSecurityRequirements(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirementsApi) {
        if (securityRequirementsApi == null || securityRequirementsApi.length == 0) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.v3.oas.annotations.security.SecurityRequirement securityRequirementApi : securityRequirementsApi) {
            if (StringUtils.isBlank((CharSequence)securityRequirementApi.name())) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addList(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
            } else {
                securityRequirement.addList(securityRequirementApi.name());
            }
            securityRequirements.add(securityRequirement);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    public static Optional<SecuritySchemePair> getSecurityScheme(io.swagger.v3.oas.annotations.security.SecurityScheme securityScheme) {
        Map extensions;
        if (securityScheme == null) {
            return Optional.empty();
        }
        String key = null;
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in().toString())) {
            securitySchemeObject.setIn(SecurityParser.getIn(securityScheme.in().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type().toString())) {
            securitySchemeObject.setType(SecurityParser.getType(securityScheme.type().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(securityScheme.openIdConnectUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.paramName())) {
            securitySchemeObject.setName(securityScheme.paramName());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.ref())) {
            securitySchemeObject.set$ref(securityScheme.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.name())) {
            key = securityScheme.name();
        }
        if (securityScheme.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])securityScheme.extensions())) != null) {
            for (Map.Entry entry : extensions.entrySet()) {
                securitySchemeObject.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
        SecurityParser.getOAuthFlows(securityScheme.flows()).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        SecuritySchemePair result = new SecuritySchemePair();
        result.key = key;
        result.securityScheme = securitySchemeObject;
        return Optional.of(result);
    }

    public static Optional<io.swagger.v3.oas.models.security.OAuthFlows> getOAuthFlows(OAuthFlows oAuthFlows) {
        Map extensions;
        if (SecurityParser.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        io.swagger.v3.oas.models.security.OAuthFlows oAuthFlowsObject = new io.swagger.v3.oas.models.security.OAuthFlows();
        if (oAuthFlows.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlows.extensions())) != null) {
            for (Map.Entry entry : extensions.entrySet()) {
                oAuthFlowsObject.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
        SecurityParser.getOAuthFlow(oAuthFlows.authorizationCode()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.clientCredentials()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.implicit()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.password()).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    public static Optional<OAuthFlow> getOAuthFlow(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        Map extensions;
        if (SecurityParser.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(oAuthFlow.authorizationUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(oAuthFlow.refreshUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(oAuthFlow.tokenUrl());
        }
        if (oAuthFlow.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlow.extensions())) != null) {
            for (Map.Entry entry : extensions.entrySet()) {
                oAuthFlowObject.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
        SecurityParser.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    public static Optional<Scopes> getScopes(OAuthScope[] scopes) {
        if (SecurityParser.isEmpty(scopes)) {
            return Optional.empty();
        }
        Scopes scopesObject = new Scopes();
        for (OAuthScope scope : scopes) {
            scopesObject.addString(scope.name(), scope.description());
        }
        return Optional.of(scopesObject);
    }

    private static SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static boolean isEmpty(OAuthFlows oAuthFlows) {
        if (oAuthFlows == null) {
            return true;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.implicit())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.authorizationCode())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.clientCredentials())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.password())) {
            return false;
        }
        return oAuthFlows.extensions().length <= 0;
    }

    private static boolean isEmpty(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (oAuthFlow == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlow.scopes())) {
            return false;
        }
        return oAuthFlow.extensions().length <= 0;
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        return scopes == null || scopes.length == 0;
    }

    public static class SecuritySchemePair {
        String key;
        SecurityScheme securityScheme;
    }
}

