/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

@Component
public class InfoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoBuilder.class);
    @Autowired
    private ApplicationContext context;

    private InfoBuilder() {
    }

    public io.swagger.v3.oas.models.info.Info build() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
        List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
        OpenAPIDefinition apiDef = this.getApiDefClass(scanner, packagesToScan);
        io.swagger.v3.oas.models.info.Info info = null;
        info = apiDef != null ? (io.swagger.v3.oas.models.info.Info)AnnotationsUtils.getInfo((Info)apiDef.info()).orElse(null) : new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
        return info;
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath: " + e.getMessage());
                }
            }
        }
        return null;
    }
}

