/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AnnotationsUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

@Component
public class RequestBuilder {
    public Operation build(Components components, HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, String[] allConsumes) {
        operation.setOperationId(handlerMethod.getMethod().getName());
        LocalVariableTableParameterNameDiscoverer d = new LocalVariableTableParameterNameDiscoverer();
        String[] pNames = d.getParameterNames(handlerMethod.getMethod());
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        Parameter[] parameters = handlerMethod.getMethod().getParameters();
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        RequestBody requestBody = null;
        Content content1 = null;
        for (int i = 0; i < pNames.length; ++i) {
            PathVariable pathVar;
            RequestParam requestParam;
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)AnnotationUtils.findAnnotation((AnnotatedElement)parameters[i], io.swagger.v3.oas.annotations.Parameter.class);
            RequestHeader requestHeader = (RequestHeader)AnnotationUtils.findAnnotation((AnnotatedElement)parameters[i], RequestHeader.class);
            if (requestHeader != null) {
                parameter.setIn("header");
                if (requestHeader.required()) {
                    parameter.setRequired(Boolean.TRUE);
                }
                if (StringUtils.isNotBlank((CharSequence)requestHeader.value())) {
                    parameter.setName(requestHeader.value());
                }
                Schema<?> schema = this.calculateSchema(components, parameters[i]);
                parameter.setSchema(schema);
            }
            if ((requestParam = (RequestParam)AnnotationUtils.findAnnotation((AnnotatedElement)parameters[i], RequestParam.class)) != null) {
                parameter.setIn("query");
                if (requestParam.required()) {
                    parameter.setRequired(Boolean.TRUE);
                }
                if (StringUtils.isNotBlank((CharSequence)requestParam.value())) {
                    parameter.setName(requestParam.value());
                }
                Schema<?> schema = this.calculateSchema(components, parameters[i]);
                parameter.setSchema(schema);
            }
            if ((pathVar = (PathVariable)AnnotationUtils.findAnnotation((AnnotatedElement)parameters[i], PathVariable.class)) != null) {
                this.setParameter("path", pathVar.value(), parameters[i].getType(), parameter);
            }
            if (RequestMethod.GET.equals((Object)requestMethod) && parameter.getIn() == null) {
                String name = parameter.getName() == null ? pNames[i] : parameter.getName();
                this.setParameter("query", name, parameters[i].getType(), parameter);
            }
            if (parameterDoc != null) {
                Map extensionMap;
                if (parameterDoc.hidden()) continue;
                if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
                    parameter = new io.swagger.v3.oas.models.parameters.Parameter().$ref(parameterDoc.ref());
                    operationParameters.add(parameter);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
                    parameter.setDescription(parameterDoc.description());
                } else if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
                    parameter.setDescription(parameterDoc.name());
                }
                if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
                    parameter.setIn(parameterDoc.in().toString());
                }
                if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
                    try {
                        parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
                    }
                    catch (IOException e) {
                        parameter.setExample((Object)parameterDoc.example());
                    }
                }
                if (parameterDoc.deprecated()) {
                    parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
                }
                if (parameterDoc.required()) {
                    parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
                }
                if (parameterDoc.allowEmptyValue()) {
                    parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
                }
                if (parameterDoc.allowReserved()) {
                    parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
                }
                HashMap exampleMap = new HashMap();
                if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
                    Optional exampleOptional = io.swagger.v3.core.util.AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
                    if (exampleOptional.isPresent()) {
                        parameter.setExample(exampleOptional.get());
                    }
                } else {
                    for (ExampleObject exampleObject : parameterDoc.examples()) {
                        io.swagger.v3.core.util.AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
                    }
                }
                if (exampleMap.size() > 0) {
                    parameter.setExamples(exampleMap);
                }
                if (parameterDoc.extensions().length > 0 && (extensionMap = io.swagger.v3.core.util.AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions())) != null && extensionMap.size() > 0) {
                    for (Map.Entry entry : extensionMap.entrySet()) {
                        parameter.addExtension((String)entry.getKey(), entry.getValue());
                    }
                }
                this.setParameterStyle(parameter, parameterDoc);
                this.setParameterExplode(parameter, parameterDoc);
            }
            if (parameter.getName() != null) {
                this.applyBeanValidatorAnnotations(parameter, Arrays.asList(parameters[i].getAnnotations()));
                operationParameters.add(parameter);
                continue;
            }
            if (RequestMethod.GET.equals((Object)requestMethod)) continue;
            requestBody = new RequestBody();
            content1 = new Content();
            Schema<?> schema = this.calculateSchema(components, parameters[i]);
            MediaType mediaType = null;
            if (schema != null && schema.getType() != null) {
                mediaType = new MediaType();
                mediaType.setSchema(schema);
            } else {
                Class<?> returnType = parameters[i].getType();
                mediaType = this.calculateSchema(components, returnType);
            }
            if (ArrayUtils.isNotEmpty((Object[])allConsumes)) {
                for (String value : allConsumes) {
                    this.setMediaTypeToContent(schema, content1, value);
                }
            } else {
                content1.addMediaType("*/*", mediaType);
            }
            requestBody.setContent(content1);
            if (parameterDoc != null) {
                if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
                    requestBody.setDescription(parameterDoc.description());
                }
                requestBody.setRequired(Boolean.valueOf(parameterDoc.required()));
            }
            operation.setRequestBody(requestBody);
        }
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        return operation;
    }

    private void setParameter(String param, String value, Class<?> type, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        parameter.setIn(param);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            parameter.setName(value);
        }
        Schema schema = AnnotationsUtils.resolveSchemaFromType(type, null, null);
        parameter.setSchema(schema);
    }

    private Schema<?> calculateSchema(Components components, Parameter parameter) {
        Schema schemaN = null;
        Type returnType = parameter.getParameterizedType();
        if (returnType instanceof ParameterizedType) {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
            if (resolvedSchema.schema != null) {
                schemaN = resolvedSchema.schema;
                Map schemaMap = resolvedSchema.referencedSchemas;
                if (schemaMap != null) {
                    schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
                }
            }
        } else {
            schemaN = io.swagger.v3.core.util.AnnotationsUtils.resolveSchemaFromType(parameter.getType(), null, null);
        }
        return schemaN;
    }

    private MediaType calculateSchema(Components components, Type returnType) {
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
        MediaType mediaType = new MediaType();
        if (resolvedSchema.schema != null) {
            Map schemaMap;
            Schema returnTypeSchema = resolvedSchema.schema;
            if (returnTypeSchema != null) {
                mediaType.setSchema(returnTypeSchema);
            }
            if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return mediaType;
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, io.swagger.v3.oas.annotations.Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private boolean isExplodable(io.swagger.v3.oas.annotations.Parameter p) {
        Class implementation;
        io.swagger.v3.oas.annotations.media.Schema schema = p.schema();
        boolean explode = true;
        if (schema != null && (implementation = schema.implementation()) == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, io.swagger.v3.oas.annotations.Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        Max max;
        Min min;
        HashMap annos = new HashMap();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), annotation));
        }
        if (annos.containsKey(NotNull.class.getName())) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            schema.setMinimum(BigDecimal.valueOf(size.min()));
            schema.setMaximum(BigDecimal.valueOf(size.max()));
            schema.setMinItems(Integer.valueOf(size.min()));
            schema.setMaxItems(Integer.valueOf(size.max()));
        }
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.valueOf(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.valueOf(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }
}

