/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class MediaAttributes {
    private String[] classProduces;
    private String[] classConsumes;
    private String[] methodProduces;
    private String[] methodConsumes;

    public String[] getClassProduces() {
        return this.classProduces;
    }

    public void setClassProduces(String[] classProduces) {
        this.classProduces = classProduces;
    }

    public String[] getClassConsumes() {
        return this.classConsumes;
    }

    public void setClassConsumes(String[] classConsumes) {
        this.classConsumes = classConsumes;
    }

    public String[] getMethodProduces() {
        return this.methodProduces;
    }

    public void setMethodProduces(String[] methodProduces) {
        this.methodProduces = methodProduces;
    }

    public String[] getMethodConsumes() {
        return this.methodConsumes;
    }

    public void setMethodConsumes(String[] methodConsumes) {
        this.methodConsumes = methodConsumes;
    }

    public void calculateConsumesProduces(RequestMethod requestMethod, Method method) {
        switch (requestMethod) {
            case POST: {
                PostMapping reqPostMappringMethod = (PostMapping)ReflectionUtils.getAnnotation((Method)method, PostMapping.class);
                if (reqPostMappringMethod == null) break;
                this.methodProduces = reqPostMappringMethod.produces();
                this.methodConsumes = reqPostMappringMethod.consumes();
                break;
            }
            case GET: {
                GetMapping reqGetMappringMethod = (GetMapping)ReflectionUtils.getAnnotation((Method)method, GetMapping.class);
                if (reqGetMappringMethod == null) break;
                this.methodProduces = reqGetMappringMethod.produces();
                this.methodConsumes = reqGetMappringMethod.consumes();
                break;
            }
            case DELETE: {
                DeleteMapping reqDeleteMappringMethod = (DeleteMapping)ReflectionUtils.getAnnotation((Method)method, DeleteMapping.class);
                if (reqDeleteMappringMethod == null) break;
                this.methodProduces = reqDeleteMappringMethod.produces();
                this.methodConsumes = reqDeleteMappringMethod.consumes();
                break;
            }
            case PUT: {
                PutMapping reqPutMappringMethod = (PutMapping)ReflectionUtils.getAnnotation((Method)method, PutMapping.class);
                if (reqPutMappringMethod == null) break;
                this.methodProduces = reqPutMappringMethod.produces();
                this.methodConsumes = reqPutMappringMethod.consumes();
                break;
            }
            default: {
                RequestMapping reqMappringMethod = (RequestMapping)ReflectionUtils.getAnnotation((Method)method, RequestMapping.class);
                if (reqMappringMethod == null) break;
                this.methodProduces = reqMappringMethod.produces();
                this.methodConsumes = reqMappringMethod.consumes();
            }
        }
    }

    public String[] getAllConsumes() {
        return (String[])ArrayUtils.addAll((Object[])this.methodConsumes, (Object[])this.classConsumes);
    }

    public String[] getAllProduces() {
        return (String[])ArrayUtils.addAll((Object[])this.methodProduces, (Object[])this.classProduces);
    }
}

