/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.InfoBuilder;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.RequestBuilder;
import org.springdoc.core.ResponseBuilder;
import org.springdoc.core.TagsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiResource.class);
    @Autowired
    private RequestBuilder requestBuilder;
    @Autowired
    private ResponseBuilder responseBuilder;
    @Autowired
    private TagsBuilder tagbuiBuilder;
    @Autowired
    private OperationBuilder operationParser;
    @Autowired
    private InfoBuilder infoBuilder;
    @Autowired
    private RequestMappingInfoHandlerMapping mappingHandler;

    @io.swagger.v3.oas.annotations.Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson() throws JsonProcessingException {
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @io.swagger.v3.oas.annotations.Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml() throws JsonProcessingException {
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    private OpenAPI getOpenApi() {
        long start = System.currentTimeMillis();
        OpenAPI openAPI = new OpenAPI();
        Components components = new Components();
        openAPI.setComponents(components);
        this.infoBuilder.build(openAPI);
        Map map = this.mappingHandler.getHandlerMethods();
        Map findRestControllers1 = this.mappingHandler.getApplicationContext().getBeansWithAnnotation(RestController.class);
        Map findRestControllers2 = this.mappingHandler.getApplicationContext().getBeansWithAnnotation(RequestMapping.class);
        Map<String, Object> findRestControllers = Stream.of(findRestControllers1, findRestControllers2).flatMap(mapEl -> mapEl.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
        Map findControllerAdvice = this.mappingHandler.getApplicationContext().getBeansWithAnnotation(ControllerAdvice.class);
        this.responseBuilder.buildGenericResponse(components, findControllerAdvice);
        Paths paths = new Paths();
        for (Map.Entry entry : map.entrySet()) {
            Optional firstpattern;
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            String operationPath = null;
            if (patterns != null && (firstpattern = patterns.stream().findFirst()).isPresent()) {
                operationPath = (String)firstpattern.get();
            }
            if (operationPath == null || !operationPath.startsWith("/") || !findRestControllers.containsKey(handlerMethod.getBean().toString())) continue;
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            for (RequestMethod requestMethod : requestMethods) {
                io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)handlerMethod.getMethod(), io.swagger.v3.oas.annotations.Operation.class);
                if (apiOperation != null && apiOperation.hidden()) continue;
                RequestMapping reqMappringClass = (RequestMapping)ReflectionUtils.getAnnotation((Class)handlerMethod.getBeanType(), RequestMapping.class);
                MediaAttributes mediaAttributes = new MediaAttributes();
                if (reqMappringClass != null) {
                    mediaAttributes.setClassConsumes(reqMappringClass.consumes());
                    mediaAttributes.setClassProduces(reqMappringClass.produces());
                }
                mediaAttributes.calculateConsumesProduces(requestMethod, handlerMethod.getMethod());
                Operation operation = new Operation();
                operation = this.tagbuiBuilder.build(handlerMethod, operation, openAPI);
                openAPI = this.operationParser.parse(components, apiOperation, operation, openAPI, mediaAttributes);
                operation = this.requestBuilder.build(components, handlerMethod, requestMethod, operation, mediaAttributes.getAllConsumes());
                ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, mediaAttributes.getAllProduces());
                operation.setResponses(apiResponses);
                PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
                paths.addPathItem(operationPath, pathItemObject);
                if (openAPI.getPaths() != null) {
                    paths.putAll((Map)openAPI.getPaths());
                }
                openAPI.setPaths(paths);
            }
        }
        LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)(System.currentTimeMillis() - start));
        return openAPI;
    }

    private PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }
}

