/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.SecurityParser;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OperationBuilder {
    public OpenAPI parse(Components components, io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, OpenAPI openAPI, MediaAttributes mediaAttributes) {
        if (apiOperation != null) {
            Map extensions;
            Optional<List<String>> mlist;
            if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
                operation.setSummary(apiOperation.summary());
            }
            if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
                operation.setDescription(apiOperation.description());
            }
            if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
                operation.setOperationId(OperationBuilder.getOperationId(apiOperation.operationId(), openAPI));
            }
            if (apiOperation.deprecated()) {
                operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
            }
            if ((mlist = OperationBuilder.getStringListFromStringArray(apiOperation.tags())).isPresent()) {
                List tags = mlist.get().stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t)).collect(Collectors.toList());
                for (String tagsItem : tags) {
                    operation.addTagsItem(tagsItem);
                }
            }
            if (operation.getExternalDocs() == null) {
                AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiOperation.externalDocs()).ifPresent(arg_0 -> ((Operation)operation).setExternalDocs(arg_0));
            }
            OperationBuilder.getApiResponses(apiOperation.responses(), mediaAttributes.getClassProduces(), mediaAttributes.getMethodProduces(), components, null).ifPresent(responses -> {
                if (operation.getResponses() == null) {
                    operation.setResponses(responses);
                } else {
                    responses.forEach((arg_0, arg_1) -> ((ApiResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
                }
            });
            AnnotationsUtils.getServers((Server[])apiOperation.servers()).ifPresent(servers -> servers.forEach(arg_0 -> ((Operation)operation).addServersItem(arg_0)));
            Optional<List<SecurityRequirement>> requirementsObject = SecurityParser.getSecurityRequirements(apiOperation.security());
            if (requirementsObject.isPresent()) {
                requirementsObject.get().stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(arg_0 -> ((Operation)operation).addSecurityItem(arg_0));
            }
            if (apiOperation != null && apiOperation.requestBody() != null && operation.getRequestBody() == null) {
                OperationBuilder.getRequestBody(apiOperation.requestBody(), mediaAttributes.getClassConsumes(), mediaAttributes.getMethodConsumes(), components, null).ifPresent(arg_0 -> ((Operation)operation).setRequestBody(arg_0));
            }
            if (apiOperation.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])apiOperation.extensions())) != null) {
                for (Map.Entry entry : extensions.entrySet()) {
                    operation.addExtension((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return openAPI;
    }

    private static String getOperationId(String operationId, OpenAPI openAPI) {
        boolean operationIdUsed = OperationBuilder.existOperationId(operationId, openAPI);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = OperationBuilder.existOperationId(operationIdToFind, openAPI);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private static boolean existOperationId(String operationId, OpenAPI openAPI) {
        if (openAPI == null) {
            return false;
        }
        if (openAPI.getPaths() == null || openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : openAPI.getPaths().values()) {
            Set<String> pathOperationIds = OperationBuilder.extractOperationIdFromPathItem(path);
            if (!pathOperationIds.contains(operationId)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> extractOperationIdFromPathItem(PathItem path) {
        HashSet<String> ids = new HashSet<String>();
        if (path.getGet() != null && StringUtils.isNotBlank((CharSequence)path.getGet().getOperationId())) {
            ids.add(path.getGet().getOperationId());
        }
        if (path.getPost() != null && StringUtils.isNotBlank((CharSequence)path.getPost().getOperationId())) {
            ids.add(path.getPost().getOperationId());
        }
        if (path.getPut() != null && StringUtils.isNotBlank((CharSequence)path.getPut().getOperationId())) {
            ids.add(path.getPut().getOperationId());
        }
        if (path.getDelete() != null && StringUtils.isNotBlank((CharSequence)path.getDelete().getOperationId())) {
            ids.add(path.getDelete().getOperationId());
        }
        if (path.getOptions() != null && StringUtils.isNotBlank((CharSequence)path.getOptions().getOperationId())) {
            ids.add(path.getOptions().getOperationId());
        }
        if (path.getHead() != null && StringUtils.isNotBlank((CharSequence)path.getHead().getOperationId())) {
            ids.add(path.getHead().getOperationId());
        }
        if (path.getPatch() != null && StringUtils.isNotBlank((CharSequence)path.getPatch().getOperationId())) {
            ids.add(path.getPatch().getOperationId());
        }
        return ids;
    }

    private static Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, String[] classProduces, String[] methodProduces, Components components, JsonView jsonViewAnnotation) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            Map extensions;
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.ref())) {
                apiResponseObject.set$ref(response.ref());
                if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                    apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                    continue;
                }
                apiResponsesObject._default(apiResponseObject);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            } else {
                apiResponseObject.setDescription("default response");
            }
            if (response.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])response.extensions())) != null) {
                for (Map.Entry entry : extensions.entrySet()) {
                    apiResponseObject.addExtension((String)entry.getKey(), entry.getValue());
                }
            }
            AnnotationsUtils.getContent((Content[])response.content(), (String[])(classProduces == null ? new String[]{} : classProduces), (String[])(methodProduces == null ? new String[]{} : methodProduces), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).content(arg_0));
            AnnotationsUtils.getHeaders((io.swagger.v3.oas.annotations.headers.Header[])response.headers(), (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((ApiResponse)apiResponseObject).headers(arg_0));
            Map headers = apiResponseObject.getHeaders();
            if (!CollectionUtils.isEmpty((Map)headers)) {
                for (Map.Entry entry : headers.entrySet()) {
                    Header header = (Header)entry.getValue();
                    if (header.getSchema() != null) continue;
                    Schema schema = AnnotationsUtils.resolveSchemaFromType(String.class, null, null);
                    header.setSchema(schema);
                    entry.setValue(header);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null && apiResponseObject.getHeaders() == null) continue;
            Map links = AnnotationsUtils.getLinks((Link[])response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(apiResponsesObject);
    }

    private static Optional<List<String>> getStringListFromStringArray(String[] array) {
        if (array == null) {
            return Optional.empty();
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean isEmpty = true;
        for (String value : array) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                isEmpty = false;
            }
            list.add(value);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    private static Optional<RequestBody> getRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, String[] classConsumes, String[] methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        } else {
            requestBodyObject.setDescription("default response");
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])requestBody.extensions());
            if (extensions != null) {
                for (Map.Entry entry : extensions.entrySet()) {
                    requestBodyObject.addExtension((String)entry.getKey(), entry.getValue());
                }
            }
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes), (String[])(methodConsumes == null ? new String[]{} : methodConsumes), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }
}

