/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.SecurityParser;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

@Component
public class InfoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoBuilder.class);
    @Autowired
    private ApplicationContext context;

    private InfoBuilder() {
    }

    public void build(OpenAPI openAPI) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
        List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
        OpenAPIDefinition apiDef = this.getApiDefClass(scanner, packagesToScan);
        io.swagger.v3.oas.models.info.Info infos = null;
        if (apiDef != null) {
            AnnotationsUtils.getInfo((Info)apiDef.info()).ifPresent(info -> openAPI.setInfo(info));
            SecurityParser.getSecurityRequirements(apiDef.security()).ifPresent(s -> openAPI.setSecurity(s));
            AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiDef.externalDocs()).ifPresent(docs -> openAPI.setExternalDocs(docs));
            AnnotationsUtils.getTags((Tag[])apiDef.tags(), (boolean)false).ifPresent(tags -> openAPI.setTags(new ArrayList(tags)));
            AnnotationsUtils.getServers((Server[])apiDef.servers()).ifPresent(servers -> openAPI.setServers(servers));
            if (apiDef.extensions().length > 0) {
                openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])apiDef.extensions()));
            }
        } else {
            infos = new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
            openAPI.setInfo(infos);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath: " + e.getMessage());
                }
            }
        }
        return null;
    }
}

