/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.SecuritySchemePair;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

public class SecurityService {
    private final PropertyResolverUtils propertyResolverUtils;

    public SecurityService(PropertyResolverUtils propertyResolverUtils) {
        this.propertyResolverUtils = propertyResolverUtils;
    }

    private static boolean isEmpty(OAuthFlows oAuthFlows) {
        boolean result = oAuthFlows == null ? true : (!SecurityService.isEmpty(oAuthFlows.implicit()) || !SecurityService.isEmpty(oAuthFlows.authorizationCode()) || !SecurityService.isEmpty(oAuthFlows.clientCredentials()) || !SecurityService.isEmpty(oAuthFlows.password()) ? false : oAuthFlows.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        boolean result = oAuthFlow == null ? true : (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl()) || !StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl()) || !StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl()) || !SecurityService.isEmpty(oAuthFlow.scopes()) ? false : oAuthFlow.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        boolean result = false;
        if (scopes == null || scopes.length == 0) {
            result = true;
        }
        return result;
    }

    public io.swagger.v3.oas.annotations.security.SecurityRequirement[] getSecurityRequirements(HandlerMethod handlerMethod) {
        Class beanType = handlerMethod.getBeanType();
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags = this.getSecurityRequirementsForClass(beanType);
        Method method = handlerMethod.getMethod();
        allSecurityTags = this.getSecurityRequirementsForMethod(method, allSecurityTags);
        return allSecurityTags != null ? allSecurityTags.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[0]) : null;
    }

    public Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> getSecurityRequirementsForMethod(Method method, Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags) {
        Set securityRequirementsMethodList;
        SecurityRequirements methodSecurity = (SecurityRequirements)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, SecurityRequirements.class);
        if (methodSecurity != null) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>(Arrays.asList(methodSecurity.value())));
        }
        if (CollectionUtils.isEmpty(allSecurityTags) && !CollectionUtils.isEmpty((Collection)(securityRequirementsMethodList = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.security.SecurityRequirement.class)))) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, securityRequirementsMethodList);
        }
        return allSecurityTags;
    }

    public Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> getSecurityRequirementsForClass(Class<?> beanType) {
        Set securityRequirementsClassList;
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags = null;
        SecurityRequirements classSecurity = (SecurityRequirements)AnnotatedElementUtils.findMergedAnnotation(beanType, SecurityRequirements.class);
        if (classSecurity != null) {
            allSecurityTags = new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>(Arrays.asList(classSecurity.value()));
        }
        if (CollectionUtils.isEmpty(allSecurityTags) && !CollectionUtils.isEmpty((Collection)(securityRequirementsClassList = AnnotatedElementUtils.findMergedRepeatableAnnotations(beanType, io.swagger.v3.oas.annotations.security.SecurityRequirement.class)))) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, securityRequirementsClassList);
        }
        return allSecurityTags;
    }

    private Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> addSecurityRequirements(Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags, Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> securityRequirementsClassList) {
        if (allSecurityTags == null) {
            allSecurityTags = new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>();
        }
        allSecurityTags.addAll(securityRequirementsClassList);
        return allSecurityTags;
    }

    public Optional<List<SecurityRequirement>> getSecurityRequirements(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirementsApi) {
        if (securityRequirementsApi == null || securityRequirementsApi.length == 0) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.v3.oas.annotations.security.SecurityRequirement securityRequirementApi : securityRequirementsApi) {
            if (StringUtils.isBlank((CharSequence)securityRequirementApi.name())) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addList(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
            } else {
                securityRequirement.addList(securityRequirementApi.name());
            }
            securityRequirements.add(securityRequirement);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    public Optional<SecuritySchemePair> getSecurityScheme(io.swagger.v3.oas.annotations.security.SecurityScheme securityScheme, Locale locale) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        String key = null;
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in().toString())) {
            securitySchemeObject.setIn(this.getIn(securityScheme.in().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type().toString())) {
            securitySchemeObject.setType(this.getType(securityScheme.type().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(this.propertyResolverUtils.resolve(securityScheme.openIdConnectUrl(), locale));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.ref())) {
            securitySchemeObject.set$ref(securityScheme.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.name())) {
            key = securityScheme.name();
            if (SecuritySchemeType.APIKEY.toString().equals(securitySchemeObject.getType().toString())) {
                securitySchemeObject.setName(securityScheme.name());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.paramName())) {
            securitySchemeObject.setName(securityScheme.paramName());
        }
        if (securityScheme.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])securityScheme.extensions());
            extensions.forEach((arg_0, arg_1) -> ((SecurityScheme)securitySchemeObject).addExtension(arg_0, arg_1));
        }
        this.getOAuthFlows(securityScheme.flows(), locale).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        SecuritySchemePair result = new SecuritySchemePair(key, securitySchemeObject);
        return Optional.of(result);
    }

    public void buildSecurityRequirement(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirements, Operation operation) {
        Optional<List<SecurityRequirement>> requirementsObject = this.getSecurityRequirements(securityRequirements);
        requirementsObject.ifPresent(requirements -> requirements.stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(arg_0 -> ((Operation)operation).addSecurityItem(arg_0)));
    }

    private Optional<io.swagger.v3.oas.models.security.OAuthFlows> getOAuthFlows(OAuthFlows oAuthFlows, Locale locale) {
        if (SecurityService.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        io.swagger.v3.oas.models.security.OAuthFlows oAuthFlowsObject = new io.swagger.v3.oas.models.security.OAuthFlows();
        if (oAuthFlows.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlows.extensions());
            extensions.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).addExtension(arg_0, arg_1));
        }
        this.getOAuthFlow(oAuthFlows.authorizationCode(), locale).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        this.getOAuthFlow(oAuthFlows.clientCredentials(), locale).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        this.getOAuthFlow(oAuthFlows.implicit(), locale).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        this.getOAuthFlow(oAuthFlows.password(), locale).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.security.OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    private Optional<OAuthFlow> getOAuthFlow(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow, Locale locale) {
        if (SecurityService.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(this.propertyResolverUtils.resolve(oAuthFlow.authorizationUrl(), locale));
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(this.propertyResolverUtils.resolve(oAuthFlow.refreshUrl(), locale));
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(this.propertyResolverUtils.resolve(oAuthFlow.tokenUrl(), locale));
        }
        if (oAuthFlow.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])oAuthFlow.extensions());
            extensions.forEach((arg_0, arg_1) -> ((OAuthFlow)oAuthFlowObject).addExtension(arg_0, arg_1));
        }
        this.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    private Optional<Scopes> getScopes(OAuthScope[] scopes) {
        Scopes scopesObject = new Scopes();
        Arrays.stream(scopes).forEach(scope -> scopesObject.addString(scope.name(), scope.description()));
        return Optional.of(scopesObject);
    }

    private SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }
}

