/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.oas.models.Operation;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springframework.web.method.HandlerMethod;

public class ActuatorOperationCustomizer
implements OperationCustomizer {
    private HashMap<String, Integer> methodCountMap = new HashMap();
    private static final Pattern pattern = Pattern.compile(".*'([^']*)'.*");

    @Override
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        if (operation.getTags() != null && operation.getTags().contains(ActuatorProvider.getTag().getName())) {
            String summary = handlerMethod.toString();
            Matcher matcher = pattern.matcher(summary);
            String operationId = operation.getOperationId();
            while (matcher.find()) {
                operationId = matcher.group(1);
            }
            if (this.methodCountMap.containsKey(operationId)) {
                Integer methodCount = this.methodCountMap.get(operationId) + 1;
                this.methodCountMap.put(operationId, methodCount);
                operationId = operationId + "_" + methodCount;
            } else {
                this.methodCountMap.put(operationId, NumberUtils.INTEGER_ONE);
            }
            if (!summary.contains("$")) {
                operation.setSummary(summary);
            }
            operation.setOperationId(operationId);
        }
        return operation;
    }
}

