/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.springdoc.core.converters.ConverterUtils;

public class ResponseSupportConverter
implements ModelConverter {
    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = Json.mapper().constructType(type.getType());
        if (javaType != null) {
            Class cls = javaType.getRawClass();
            if (ConverterUtils.isResponseTypeWrapper(cls)) {
                JavaType innerType = javaType.getBindings().getBoundType(0);
                if (innerType == null) {
                    return new StringSchema();
                }
                if (innerType.getBindings() != null && ConverterUtils.isResponseTypeWrapper(innerType.getRawClass())) {
                    type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).ctxAnnotations(type.getCtxAnnotations()).resolveAsRef(true);
                    return this.resolve(type, context, chain);
                }
                type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).ctxAnnotations(type.getCtxAnnotations()).resolveAsRef(true);
            } else if (ConverterUtils.isResponseTypeToIgnore(cls)) {
                return null;
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

