/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.lang.reflect.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterInfo {
    private final MethodParameter methodParameter;
    private String pName;
    private io.swagger.v3.oas.models.parameters.Parameter parameterModel;
    private RequestHeader requestHeader;
    private RequestParam requestParam;
    private PathVariable pathVar;
    private CookieValue cookieValue;

    public ParameterInfo(String pName, MethodParameter methodParameter) {
        this.methodParameter = methodParameter;
        this.requestHeader = (RequestHeader)methodParameter.getParameterAnnotation(RequestHeader.class);
        this.requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
        this.pathVar = (PathVariable)methodParameter.getParameterAnnotation(PathVariable.class);
        this.cookieValue = (CookieValue)methodParameter.getParameterAnnotation(CookieValue.class);
        this.pName = this.calculateName(pName, this.requestHeader, this.requestParam, this.pathVar, this.cookieValue);
    }

    public String getpName() {
        return this.pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Parameter getParameter() {
        return this.methodParameter.getParameter();
    }

    public io.swagger.v3.oas.models.parameters.Parameter getParameterModel() {
        return this.parameterModel;
    }

    public void setParameterModel(io.swagger.v3.oas.models.parameters.Parameter parameterModel) {
        this.parameterModel = parameterModel;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public RequestParam getRequestParam() {
        return this.requestParam;
    }

    public PathVariable getPathVar() {
        return this.pathVar;
    }

    public CookieValue getCookieValue() {
        return this.cookieValue;
    }

    private String calculateName(String pName, RequestHeader requestHeader, RequestParam requestParam, PathVariable pathVar, CookieValue cookieValue) {
        String name = pName;
        if (requestHeader != null && StringUtils.isNotEmpty((CharSequence)requestHeader.value())) {
            name = requestHeader.value();
        } else if (requestParam != null && StringUtils.isNotEmpty((CharSequence)requestParam.value())) {
            name = requestParam.value();
        } else if (pathVar != null && StringUtils.isNotEmpty((CharSequence)pathVar.value())) {
            name = pathVar.value();
        } else if (cookieValue != null && StringUtils.isNotEmpty((CharSequence)cookieValue.value())) {
            name = cookieValue.value();
        }
        return name;
    }
}

