/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.models;

import io.swagger.v3.oas.annotations.Operation;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.RouterFunctionData;
import org.springframework.web.bind.annotation.RequestMethod;

public class RouterOperation {
    private String path;
    private RequestMethod[] methods;
    private String[] consumes;
    private String[] produces;
    private String[] headers;
    private Class<?> beanClass;
    private String beanMethod;
    private Class<?>[] parameterTypes;
    private Map<String, String> queryParams;
    private Operation operation;

    public RouterOperation(org.springdoc.core.annotations.RouterOperation routerOperationAnnotation) {
        this.path = routerOperationAnnotation.path();
        this.methods = routerOperationAnnotation.method();
        this.consumes = routerOperationAnnotation.consumes();
        this.produces = routerOperationAnnotation.produces();
        this.beanClass = routerOperationAnnotation.beanClass();
        this.beanMethod = routerOperationAnnotation.beanMethod();
        this.parameterTypes = routerOperationAnnotation.parameterTypes();
        this.operation = routerOperationAnnotation.operation();
        this.headers = routerOperationAnnotation.headers();
    }

    public RouterOperation(org.springdoc.core.annotations.RouterOperation routerOperationAnnotation, RouterFunctionData routerFunctionData) {
        this.path = StringUtils.isBlank((CharSequence)routerOperationAnnotation.path()) ? routerFunctionData.getPath() : routerOperationAnnotation.path();
        this.methods = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.method()) ? routerFunctionData.getMethods() : routerOperationAnnotation.method();
        this.consumes = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.consumes()) ? routerFunctionData.getConsumes() : routerOperationAnnotation.consumes();
        this.produces = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.produces()) ? routerFunctionData.getProduces() : routerOperationAnnotation.produces();
        this.beanClass = routerOperationAnnotation.beanClass();
        this.beanMethod = routerOperationAnnotation.beanMethod();
        this.parameterTypes = routerOperationAnnotation.parameterTypes();
        this.operation = routerOperationAnnotation.operation();
        this.headers = ArrayUtils.isEmpty((Object[])routerOperationAnnotation.headers()) ? routerFunctionData.getHeaders() : routerOperationAnnotation.headers();
        this.queryParams = routerFunctionData.getQueryParams();
    }

    public RouterOperation(String path, RequestMethod[] methods) {
        this.path = path;
        this.methods = methods;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RequestMethod[] getMethods() {
        return this.methods;
    }

    public void setMethods(RequestMethod[] methods) {
        this.methods = methods;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String[] consumes) {
        this.consumes = consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String getBeanMethod() {
        return this.beanMethod;
    }

    public void setBeanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }
}

